/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.security.jwt;

import com.notrecontinent.webapi.security.jwt.AESUtil;
import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.security.services.UserDetailsServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.server.ResponseStatusException;

public class AuthTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private AESUtil aesUtil;
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);
    private final List<String> origins = new ArrayList<String>(Arrays.asList("http://localhost:4200", "https://hostspeaky.com"));
    private final String[] browsers = new String[]{"Chrome", "Firefox", "Safari", "Opera", "MSIE", "Trident", "Edge"};
    private final List<String> whitelistUrls = new ArrayList<String>(Arrays.asList("/api/momar/Auteur/authenticate", "/api/momar/Auteur", "/api/momar/Auteur/resetpwd/{numero}/{newpwd}", "/api/momar/Auteur/verif/{username}/{pays}", "/api/momar/Auteur/verifcompte/{username}/{pays}", "/api/momar/Auteur/verifier/{pseudonyme}", "/api/momar/Auteur/savepays/{id}", "/api/momar/Mail/erreur", "/api/momar/AuthToken", "/api/momar/SendSMSCode", "/api/momar/VerifSMSCode", "/api/momar/Bug", "/api/momar/Auteur/deconnexion", "/api/speaky/Admin/deconnexion", "/api/momar/Auteur/SendValidationEmail", "/api/momar/Auteur/ResendEmailConfirmation", "/api/momar/Auteur/VerifEmailValidationTokenAndSaveAuteur", "/api/momar/Mail/resetpwd", "/api/momar/Auteur/verifresetpwdtoken", "/api/momar/Auteur/verifEmailAndSendResetPwdEmail", "/api/momar/Auteur/verifyUsernameAndSendSmSCode", "/api/momar/Auteur/verifynumeroAndSendResetSmSCode", "/api/momar/Auteur/VerifierSmsCodeEtSaveAuteur/{code}/{canal}", "/api/momar/Auteur/ConnecterDirectementAuteurLP", "/api/momar/NotificationSms/ConnecterDirectementAuteur", "/api/momar/NotificationSms/VerifierParamLienSms", "/api/momar/Auteur/enregistrercode1234", "/api/momar/Auteur/verifierComptewhatsapp", "/api/momar/Auteur/validernumwhatsappsecondeinstance", "/api/momar/Recommandation/update/status", "/api/momar/Auteur/admin/signin", "/api/momar/whatsapp/sendcodevalidation", "/api/momar/whatsapp/sendcodevalidationtelephone", "/api/momar/Auteur/verifyCompte/{username}", "/api/momar/Auteur/desinscrireEmail/{id}", "/api/momar/Auteur/verifyUsernameAndSendResetCode", "/api/momar/Chatbot/VerifierNumWhatsapp8152", "/api/momar/Chatbot/VerifierNumWhatsapp1134"));

    private boolean isBrowserRequest(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        for (String browser : this.browsers) {
            if (!userAgent.contains(browser)) continue;
            return true;
        }
        return false;
    }

    private boolean isRequestOriginAutorized(String origin) {
        if (origin == null) {
            return false;
        }
        return this.origins.contains(origin);
    }

    private boolean isWhitelistedRequestUrl(String url) {
        if (url == null) {
            return false;
        }
        return this.whitelistUrls.contains(url);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block9: {
            if (Arrays.asList("/api/momar/Auteur/enregistrercode1234", "/api/momar/Chatbot/VerifierNumWhatsapp8152", "/api/momar/Chatbot/VerifierNumWhatsapp1134", "/api/momar/Recommandation/update/status").contains(request.getRequestURI())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String origin = request.getHeader("Origin");
            System.out.println("Origin : " + origin);
            if (!this.isRequestOriginAutorized(origin)) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Non autoris\u00e9 : acc\u00e8s refus\u00e9.");
            }
            String compte = request.getHeader("compte");
            if (compte != null) {
                System.out.println("compte:" + compte);
            }
            String userAgent = request.getHeader("User-Agent");
            System.out.println("user agent : " + userAgent);
            if (!this.isBrowserRequest(userAgent)) {
                System.out.println("ce n'est pas un navigateur");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Non autoris\u00e9 : acc\u00e8s refus\u00e9.");
            }
            String tokenHeader = request.getHeader("Authorization");
            if (tokenHeader != null && tokenHeader.startsWith("Bearer ")) {
                String token = tokenHeader.substring(7);
                try {
                    if (token == null || !this.jwtUtils.validateJwtToken(token = this.aesUtil.decryptt(token))) break block9;
                    Long idheader = Long.valueOf(request.getHeader("idcompte"));
                    Long id = this.jwtUtils.getokenUserID(token);
                    System.out.println("id du header (du compte) : " + idheader);
                    System.out.println("id de g\u00e9n\u00e9ration du token : " + id);
                    if (Objects.equals(id, idheader)) {
                        String role = this.jwtUtils.getokenRole(token);
                        String requestUrl = request.getRequestURI();
                        if (requestUrl.startsWith("/api/speaky") && !role.equals("admin")) {
                            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Non autoris\u00e9 : acc\u00e8s refus\u00e9.");
                        }
                        String username = this.jwtUtils.getUserNameFromJwtToken(token);
                        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                        break block9;
                    }
                    throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Non autoris\u00e9 : acc\u00e8s refus\u00e9.");
                }
                catch (Exception e) {
                    logger.error("Cannot set user authentication: {}", (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Non autoris\u00e9 : acc\u00e8s refus\u00e9.");
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

