/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.security.jwt;

import com.notrecontinent.webapi.LesDTOs.UsernamePassword;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtils.class);
    private static final String SECRET_KEY = "Di@%-m@9^yl@ye1995@!!!!&&&@10/23?###";
    @Value(value="${momar.app.jwtSecret}")
    private String jwtSecret;
    @Value(value="${momar.app.jwtExpirationMs}")
    private int jwtExpirationMs;
    @Value(value="${momar.app.jwtCookieName}")
    private String jwtCookie;

    public UsernamePassword getUserNameAndPasswordFromJwtToken(String token) {
        String username = ((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).getSubject();
        String password = (String)((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).get("password", String.class);
        return new UsernamePassword(username, password);
    }

    public String getUserNameFromJwtToken(String token) {
        return ((Claims)Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody()).getSubject();
    }

    public Long getokenUserID(String token) {
        return (Long)((Claims)Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody()).get("id", Long.class);
    }

    public String getokenRole(String token) {
        return (String)((Claims)Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody()).get("role", String.class);
    }

    public boolean validateJwtToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException e) {
            logger.error("Invalid JWT signature: {}", (Object)e.getMessage());
        }
        catch (MalformedJwtException e) {
            logger.error("Invalid JWT token: {}", (Object)e.getMessage());
        }
        catch (ExpiredJwtException e) {
            logger.error("JWT token is expired: {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            logger.error("JWT token is unsupported: {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("JWT claims string is empty: {}", (Object)e.getMessage());
        }
        return false;
    }

    public String generateTokenFromUsernameAndidAndrole(String username, String password, Long id, String role) {
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.jwtExpirationMs)).claim("id", (Object)id).claim("role", (Object)role).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public String generateTokenFromUsername(String username, String password, Long id) {
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.jwtExpirationMs)).claim("id", (Object)id).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public String generateTokenFromUsernameOnly(String username) {
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + 900000L)).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public String generateTokenFromUsernameAndPassword(String username, String password) {
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + 900000L)).claim("password", (Object)password).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public String generateTokenFromUsernameAndPasswordAndparam(String username, Map<String, Object> additionalClaims) {
        HashMap<String, Object> claims = new HashMap<String, Object>(additionalClaims);
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + 900000L)).setClaims(claims).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public UsernamePassword getUserNameAndPasswordandparamFromJwtToken(String token) {
        String username = ((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).getSubject();
        String username2 = (String)((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).get("username", String.class);
        String password = (String)((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).get("pwd", String.class);
        String param = (String)((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).get("param", String.class);
        System.out.println(username);
        System.out.println(username2);
        System.out.println(password);
        System.out.println(param);
        System.out.println(Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody());
        return new UsernamePassword(username2, password, param);
    }
}

