/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.entities.Categorie;
import com.notrecontinent.webapi.repositories.CategorieRepository;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class CategorieService {
    @Autowired
    private CategorieRepository categorieRepository;
    @Autowired
    private RestTemplate restTemplate;

    @Transactional
    public void UpdateCategoriesWP() {
        List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
        if (!categories.isEmpty()) {
            for (Categorie categorie : categories) {
                categorie.setName(categorie.getName().replace("&amp;", "&"));
            }
            this.categorieRepository.saveAll(categories);
        }
    }

    public ResponseEntity<List<Categorie>> getAllCategories() throws JsonProcessingException {
        List categories = this.categorieRepository.findAll();
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonstring = objectMapper.writeValueAsString((Object)categories);
        long contentlength = jsonstring.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentlength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)categories);
    }
}

