/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsContributeur;
import com.notrecontinent.webapi.entities.PointsLienPrivilege;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsContributeurService {
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private PointLienPrivilegeRepository pointLienPrivilegeRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private AuteurRepository auteurRepository;

    @Transactional
    public void MAJPointsArticlesValides() {
        List articleList1;
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String mois = dateFormat.format(dateelastmonth);
        List articleList = this.articleRepository.findArticlesvalideslastmonth(dateelastmonth);
        if (!articleList.isEmpty() && !(articleList1 = articleList.stream().filter(a -> dateFormat.format(a.getDatepublication()).equals(mois)).collect(Collectors.toList())).isEmpty()) {
            for (Article a2 : articleList1) {
                PointsContributeur pointsContributeur = this.pointsContributeurRepository.findByLienarticle(a2.getLink());
                if (pointsContributeur != null) continue;
                PointsContributeur p = new PointsContributeur();
                p.setMois(mois);
                p.setNbpoints(Long.valueOf(100L));
                p.setContributeurid(a2.getAuteurID());
                p.setTitrearticle(a2.getTitre());
                p.setLienarticle(a2.getLink());
                p.setStatusarticle(a2.getStatus());
                this.pointsContributeurRepository.save((Object)p);
            }
        }
    }

    @Transactional
    public void MAJPointsContributeur() {
        List pointsLienPrivilegeList;
        Auteur contributeur;
        List pointsContributeurList = this.pointsContributeurRepository.findAll();
        if (!pointsContributeurList.isEmpty()) {
            HashSet<Long> contributeursids = new HashSet<Long>();
            for (PointsContributeur p2 : pointsContributeurList) {
                contributeursids.add(p2.getContributeurid());
            }
            ArrayList contributeuridsList = new ArrayList(contributeursids);
            if (!contributeuridsList.isEmpty()) {
                for (Long contributeurid : contributeuridsList) {
                    List pointsContributeurs = pointsContributeurList.stream().filter(p -> Objects.equals(p.getContributeurid(), contributeurid)).collect(Collectors.toList());
                    if (pointsContributeurs.isEmpty() || (contributeur = (Auteur)this.auteurRepository.findById((Object)contributeurid).get()).getMonetisation() == null || !contributeur.getMonetisation().equals("Oui")) continue;
                    Long totalpoints = 0L;
                    for (PointsContributeur p3 : pointsContributeurs) {
                        totalpoints = totalpoints + p3.getNbpoints();
                    }
                    contributeur.setTotalPointsCumules(totalpoints);
                    this.auteurRepository.save((Object)contributeur);
                }
            }
        }
        if (!(pointsLienPrivilegeList = this.pointLienPrivilegeRepository.findByRolecompte("contributeur")).isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>();
            for (PointsLienPrivilege p4 : pointsLienPrivilegeList) {
                ids.add(p4.getAuteurid());
            }
            for (Long contributeurid : ids) {
                List pointsLienPrivileges = pointsLienPrivilegeList.stream().filter(p -> Objects.equals(p.getAuteurid(), contributeurid)).collect(Collectors.toList());
                contributeur = (Auteur)this.auteurRepository.findById((Object)contributeurid).get();
                if (contributeur.getMonetisation() == null || !contributeur.getMonetisation().equals("Oui")) continue;
                Long totalpointscontributeur = contributeur.getTotalPointsCumules();
                for (PointsLienPrivilege pointsLienPrivilege : pointsLienPrivileges) {
                    totalpointscontributeur = totalpointscontributeur + pointsLienPrivilege.getNbPointsComptesCreer();
                }
                contributeur.setTotalPointsCumules(totalpointscontributeur);
                this.auteurRepository.save((Object)contributeur);
            }
        }
    }

    public List<PointsContributeur> getAllByContributeurid(Long id) {
        return this.pointsContributeurRepository.findByContributeurid(id);
    }

    @Transactional
    public void VerifAndAddPointContributeur(String lienarticle, String titrearticle, Long contributeurid, String statusarticle) {
        PointsContributeur pointsContributeur = this.pointsContributeurRepository.findByLienarticle(lienarticle);
        if (pointsContributeur == null) {
            PointsContributeur p = new PointsContributeur();
            p.setLienarticle(lienarticle);
            p.setTitrearticle(titrearticle);
            p.setContributeurid(contributeurid);
            p.setStatusarticle(statusarticle);
            if (statusarticle.equals("Valid\u00e9 (en ligne)")) {
                p.setNbpoints(Long.valueOf(100L));
            }
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            p.setMois(mois);
            this.pointsContributeurRepository.save((Object)p);
        }
    }
}

