/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Paiement;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.PointsContributeur;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ModePaiementRepository;
import com.notrecontinent.webapi.repositories.PaiementRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import com.notrecontinent.webapi.repositories.TransactionRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaiementService {
    @Autowired
    private PaiementRepository paiementRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private ModePaiementRepository modePaiementRepository;
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private BugsCronService bugsCronService;

    public ResponseEntity<List<Transaction>> getTransactionsByAuteurID(Long id) throws JsonProcessingException {
        List transactions = this.transactionRepository.findByAuteuridAndEstconfirmerOrderByDateCreationDesc(id, Boolean.valueOf(true));
        if (!transactions.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)transactions).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)transactions);
        }
        ArrayList transactionList = new ArrayList();
        long contentLength = this.mapper.writeValueAsString(transactionList).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(transactionList);
    }

    @Transactional
    public String updatePaiementok(Long idtransaction) {
        Transaction transaction = (Transaction)this.transactionRepository.findById((Object)idtransaction).get();
        transaction.setPaiementok(Boolean.valueOf(true));
        this.transactionRepository.save((Object)transaction);
        return "ok";
    }

    @Transactional
    public String updateApayerplustardok(Long idtransaction) {
        Transaction transaction = (Transaction)this.transactionRepository.findById((Object)idtransaction).get();
        transaction.setApayerplustardok(Boolean.valueOf(true));
        this.transactionRepository.save((Object)transaction);
        return "ok";
    }

    @Transactional
    public void CalculerPointsMoisPrecedent() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("ami");
        roles.add("contributeur");
        List auteurs = this.auteurRepository.findByMonetisationAndRoleIn("Oui", roles);
        if (!auteurs.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            LocalDateTime currentdate = LocalDateTime.now(ZoneId.of("GMT"));
            LocalDateTime oneMonthBeforeCurrentdate = currentdate.minusMonths(1L);
            Date dateMoisPrecedent = Date.from(oneMonthBeforeCurrentdate.atZone(ZoneId.of("GMT")).toInstant());
            String moisprecedent = dateFormat.format(dateMoisPrecedent);
            ArrayList<Paiement> paiementList = new ArrayList<Paiement>();
            for (Auteur auteur : auteurs) {
                try {
                    List pointsContributeurs;
                    Paiement paiement;
                    if (auteur.getRole().equals("ami")) {
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(moisprecedent, auteur.getId());
                        if (pointsAmi == null) continue;
                        paiement = new Paiement();
                        paiement.setNom(auteur.getLast_name());
                        paiement.setPrenom(auteur.getFirst_name());
                        paiement.setIdentification(auteur.getNumeropiece());
                        paiement.setTypepiece(auteur.getTypepiece());
                        paiement.setAuteurID(auteur.getId());
                        paiement.setMois(moisprecedent);
                        paiement.setNbpoints(pointsAmi.getNbPointsMois());
                        paiementList.add(paiement);
                        continue;
                    }
                    if (!auteur.getRole().equals("contributeur") || (pointsContributeurs = this.pointsContributeurRepository.findByMoisAndContributeurid(moisprecedent, auteur.getId())).isEmpty()) continue;
                    paiement = new Paiement();
                    paiement.setNom(auteur.getLast_name());
                    paiement.setPrenom(auteur.getFirst_name());
                    paiement.setIdentification(auteur.getNumeropiece());
                    paiement.setTypepiece(auteur.getTypepiece());
                    paiement.setAuteurID(auteur.getId());
                    paiement.setMois(moisprecedent);
                    Long nbpointsmois = 0L;
                    for (PointsContributeur p : pointsContributeurs) {
                        nbpointsmois = nbpointsmois + p.getNbpoints();
                    }
                    paiement.setNbpoints(nbpointsmois);
                    paiementList.add(paiement);
                }
                catch (Exception e) {
                    System.out.println("----------------------------------------------------");
                    System.out.println("Message du bug");
                    System.out.println(e.getMessage());
                    System.out.println("----------------------------------------------------");
                    this.bugsCronService.SaveBugCron("Cron de calcul des points du compte" + auteur.getUsername() + "pour le mois de " + moisprecedent, e.getMessage());
                }
            }
            this.paiementRepository.saveAll(paiementList);
        }
    }

    public List<Paiement> getPaiementsByAuteurID(Long id) {
        return this.paiementRepository.findByAuteurID(id);
    }

    @Transactional
    public Paiement savePaiement(Paiement paiement) {
        paiement.setDate(new Date());
        return (Paiement)this.paiementRepository.save((Object)paiement);
    }
}

