/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.AlerteBlocageProfil;
import com.notrecontinent.webapi.entities.AlertesEtreAppeler;
import com.notrecontinent.webapi.entities.CreationResetCompte;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.Monsupport;
import com.notrecontinent.webapi.repositories.CreationResetCompteRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailService {
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private CreationResetCompteRepository creationResetCompteRepository;

    public String sendCreationCompteEmail(String username) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un nouveau compte vient d'\u00eatre cr\u00e9\u00e9.</p>";
        body = body + "<p><b>Identifiant:</b> " + username + "</p>";
        String subject = "Nouveau compte";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("creationcompte@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String connexionEmail(String username, String date) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Le cr\u00e9ateur de contenu qui avait cr\u00e9er un compte le <b>" + date + "</b> avec l'identifiant <b>" + username + "</b> vient de se connecter.</p>";
        String subject = "Nouvelle connexion";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("connexioncompte@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendProfilEmail(String username, String civilite, String prenom, String nom, String adresse, String pays, String departement, String typecompte, String pseudonyme) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un cr\u00e9ateur de contenu vient de renseigner son profil.</p>";
        body = body + "<p><b>Identifiant:</b> " + username + "</p>";
        body = body + "<p><b>Civilit\u00e9:</b> " + civilite + " </p>";
        body = body + "<p><b>Pr\u00e9nom:</b> " + prenom + "</p>";
        body = body + "<p><b>Nom:</b> " + nom + "</p>";
        body = body + "<p><b>Adresse:</b> " + adresse + "</p>";
        body = body + "<p><b>Pays:</b> " + pays + "</p>";
        body = body + "<p><b>D\u00e9partement:</b> " + departement + "</p>";
        body = body + "<p><b>Type de compte:</b> " + typecompte + "</p>";
        body = body + "<p><b>Pseudonyme:</b> " + pseudonyme + "</p>";
        String subject = "Profil renseign\u00e9";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("creationprofil@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendErreurConnexionMail(String username, String password) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un utilisateur vient de rencontrer un \u00e9chec de connexion sur https://dev.speakyfree.com .</p>";
        body = body + "<br>";
        body = body + "<p>Username: " + username + "</p>";
        String subject = "Nouvelle tentative de connexion";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendValidationCompteEmail(String username, String token) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour, " : "Bonsoir, ";
        String lien = "https://dev.speakyfree.com/validation-email/" + token + "/" + username;
        String lienValidation = "<a href=\"" + lien + "\">" + lien + "</a>";
        String body = "<p>" + salutation + "</p>";
        body = body + "<p>Veuillez cliquer sur le lien ci-dessous pour confirmer la cr\u00e9ation de votre compte : </p>";
        body = body + "<br><p>" + lienValidation + "</p>";
        body = body + "<br><br>";
        body = body + "<p>Ce lien expire dans 15 minutes.</p>";
        String subject = "Validation de compte dev.speakyfree sur Notre Continent";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo(username);
        helper.setSubject(subject);
        helper.setText(body, true);
        System.out.println(username);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    @Transactional
    public String sendValidationResetEmail(String username, String token) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour, " : "Bonsoir, ";
        String lien = "https://dev.speakyfree.com/reinitialisation-motdepasse/" + token + "/" + username;
        String lienValidation = "<a href=\"" + lien + "\">" + lien + "</a>";
        String body = "<p>" + salutation + "</p>";
        body = body + "<p>Veuillez cliquer sur le lien ci-dessous pour r\u00e9initialiser votre mot de passe : </p>";
        body = body + "<br><p>" + lienValidation + "</p>";
        body = body + "<br><br>";
        body = body + "<p>Ce lien expire dans 15 minutes.</p>";
        String subject = "R\u00e9initialisation de mot de passe dev.speakyfree sur Notre Continent";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo(username);
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        CreationResetCompte creationResetCompte = new CreationResetCompte();
        creationResetCompte.setCanal("email");
        creationResetCompte.setType("r\u00e9initialisation de mot de passe");
        creationResetCompte.setUsername(username);
        this.creationResetCompteRepository.save((Object)creationResetCompte);
        return "mail successfully sent";
    }

    public String EnvoyerEmailRecommandationAunAmi(String numeroExpediteur, String nomExpediteur, String nomRecepteur, String numeroRecepteur, String msg) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour" : "Bonsoir";
        String lien = "<a href=\" + https://dev.speakyfree.com/inscription\">cliquer ici</a>";
        String lien2 = "<a href=\"https://sn.notrecontinent.com\">cliquant ici</a>";
        String body = "<p>Bonjour " + nomRecepteur + ", c'est " + nomExpediteur + ", </p>";
        body = body + "<p>Comme j'utilise la plateforme de Notre Continent pour t'envoyer ce mail voici mon adresse email pour que tu puisses savoir que c'est bien moi " + numeroExpediteur + ".</p>";
        body = body + "<p>Je te recommande de cr\u00e9er ton compte \u00ab Ami(e) \u00bb sur le site de NOTRE CONTINENT, ils ont un syst\u00e8me tr\u00e8s int\u00e9ressant de r\u00e9mun\u00e9ration des visiteurs tout en te donnant des informations utiles.</p>";
        body = body + "<p>Tu peux " + lien + " pour cr\u00e9er ton compte ou aller sur leur site web en " + lien2 + ".</p>";
        body = body + "<p>Bien \u00e0 toi</p>";
        body = body + "<p>" + nomExpediteur + " <br> " + numeroExpediteur + "</p>";
        String subject = nomRecepteur + ", donne un coup d'\u0153il sur ma recommandation";
        helper.setFrom("infosn@notrecontinent.net", nomExpediteur);
        helper.setTo(numeroRecepteur);
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public List<Long> envoyerAlertesClics(List<List<String>> emails) {
        ArrayList<Long> idsamis = new ArrayList<Long>();
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true);
            String salutation = "";
            LocalTime localTime = LocalTime.now();
            int currentHour = localTime.getHour();
            salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
            for (List<String> email : emails) {
                String body = "<p>" + salutation + " " + email.get(2) + ", il est interdit de cliquer sur 3 articles en moins de 2 minutes. Nous vous recommandons de lire les articles en prenant votre temps entre chaque clic sur une nouvelle notification afin d'\u00e9viter d'avoir des rejets. </p>";
                body = body + "<p><b>IMPORTANT:</b> Ne pas r\u00e9pondre \u00e0 ce message sur ce num\u00e9ro c'est un chatbot ou robot qui vous r\u00e9pond. Si vous souhaitez entrer en contact avec NOTRE CONTINENT, appeler ou envoyer un message sur le num\u00e9ro suivant : +221 78 888 1134</p>";
                String subject = "Alerte clic recommadations";
                try {
                    helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
                    helper.setTo(email.get(1));
                    helper.setSubject(subject);
                    helper.setText(body, true);
                    this.mailSender.send(message);
                    idsamis.add(Long.valueOf(email.get(0)));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (MessagingException e) {
            System.out.println(e.getMessage());
        }
        return idsamis;
    }

    public String SendAlerteSupport(List<Monsupport> monsupportList) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String subject = "Nouveaux tickets en attente de r\u00e9ponse";
        String body = "";
        for (Monsupport monsupport : monsupportList) {
            body = body + "<p>--> Compte : " + monsupport.getCompteusername();
            body = body + "<br>    Objet : " + monsupport.getObjet();
            body = body + "<br>    Message : " + monsupport.getDescription();
            body = body + "</p>";
        }
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "OK";
    }

    public String SendAlerteEtreAppeler(List<AlertesEtreAppeler> alertesEtreAppelerList) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String subject = "Des amis de Notre Continent veulent \u00eatre appel\u00e9s";
        String body = "";
        for (AlertesEtreAppeler a : alertesEtreAppelerList) {
            body = body + "<p>";
            body = body + "--> Nom complet: " + a.getName() + "<br>";
            body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
            body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
            body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
            body = body + "--> T\u00e9l\u00e9phone : " + a.getContact() + "<br>";
            body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
            body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
            body = body + "</p>";
        }
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "OK";
    }

    @Transactional
    public List<AlerteBlocageProfil> sendAlertProfilIncomplets(List<AlerteBlocageProfil> blocageProfilList, String objet) throws MessagingException, UnsupportedEncodingException {
        Boolean blocagestep2 = objet.equals("Blocage \u00e0 l'\u00e9tape de renseignement des informations personnelles");
        Boolean blocagestepcode1234 = objet.equals("Blocage \u00e0 l'\u00e9tape d'envoi du code 1234 WhatsApp");
        Boolean blocagestepcategories = objet.equals("Blocage \u00e0 l'\u00e9tape de s\u00e9lection des centres d'int\u00e9r\u00eats");
        Boolean blocagestepmonetisation = objet.equals("Blocage \u00e0 l'\u00e9tape de choix de la mon\u00e9tisation");
        Boolean blocagestepmodepaiement = objet.equals("Blocage \u00e0 l'\u00e9tape du mode de paiement");
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String subject = "";
        String body = "";
        if (blocagestep2.booleanValue()) {
            subject = "Comptes avec profil non renseign\u00e9";
            body = body + "<p>Les comptes bloqu\u00e9s \u00e0 l'\u00e9tape de renseignement des informations personnelles : </p>";
            for (AlerteBlocageProfil a : blocageProfilList) {
                body = body + "<p>";
                body = body + "--> Nom complet: " + a.getNamecompte() + "<br>";
                body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
                body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
                body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
                body = body + "--> type de compte : " + a.getTypecompte() + "<br>";
                body = body + "--> T\u00e9l\u00e9phone : " + a.getCompte() + "<br>";
                body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
                body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
                body = body + "</p>";
            }
        }
        if (blocagestepcode1234.booleanValue()) {
            subject = "Comptes avec code 1234 WhatsApp non envoyer";
            body = body + "<p>Les comptes bloqu\u00e9s \u00e0 l'\u00e9tape d'envoi du code 1234 sur Whatsapp : </p>";
            for (AlerteBlocageProfil a : blocageProfilList) {
                body = body + "<p>";
                body = body + "--> Nom complet: " + a.getNamecompte() + "<br>";
                body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
                body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
                body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
                body = body + "--> type de compte : " + a.getTypecompte() + "<br>";
                body = body + "--> T\u00e9l\u00e9phone : " + a.getCompte() + "<br>";
                body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
                body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
                body = body + "</p>";
            }
            body = body + "</p>";
        }
        if (blocagestepcategories.booleanValue()) {
            subject = "Comptes avec centres d'int\u00e9r\u00eats non renseign\u00e9s";
            body = body + "<p>Les comptes bloqu\u00e9s \u00e0 l'\u00e9tape de s\u00e9lection des centres d'int\u00e9r\u00eats : </p>";
            for (AlerteBlocageProfil a : blocageProfilList) {
                body = body + "<p>";
                body = body + "--> Nom complet: " + a.getNamecompte() + "<br>";
                body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
                body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
                body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
                body = body + "--> type de compte : " + a.getTypecompte() + "<br>";
                body = body + "--> T\u00e9l\u00e9phone : " + a.getCompte() + "<br>";
                body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
                body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
                body = body + "</p>";
            }
        }
        if (blocagestepmonetisation.booleanValue()) {
            subject = "Comptes avec mon\u00e9tisation non renseign\u00e9";
            body = body + "<p>Les comptes bloqu\u00e9s \u00e0 l'\u00e9tape de choix de la mon\u00e9tisation : </p>";
            for (AlerteBlocageProfil a : blocageProfilList) {
                body = body + "<p>";
                body = body + "--> Nom complet: " + a.getNamecompte() + "<br>";
                body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
                body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
                body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
                body = body + "--> type de compte : " + a.getTypecompte() + "<br>";
                body = body + "--> T\u00e9l\u00e9phone : " + a.getCompte() + "<br>";
                body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
                body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
                body = body + "</p>";
            }
        }
        if (blocagestepmodepaiement.booleanValue()) {
            subject = "Comptes avec mode de paiement non renseign\u00e9";
            body = body + "<p>Les comptes bloqu\u00e9s \u00e0 l'\u00e9tape du mode de paiement : </p>";
            for (AlerteBlocageProfil a : blocageProfilList) {
                body = body + "<p>";
                body = body + "--> Nom complet: " + a.getNamecompte() + "<br>";
                body = body + "--> Nom d'utilisateur: " + a.getUsername() + "<br>";
                body = body + "--> Date de cr\u00e9ation" + a.getDatedecreation() + "<br>";
                body = body + "--> Pays de cr\u00e9ation" + a.getPays() + "<br>";
                body = body + "--> type de compte : " + a.getTypecompte() + "<br>";
                body = body + "--> T\u00e9l\u00e9phone : " + a.getCompte() + "<br>";
                body = body + "--> Num\u00e9ro whatsapp : " + a.getNumwhatsapp() + "<br>";
                body = body + "--> Total des points cumul\u00e9s : " + a.getTotalpoints() + "<br>";
                body = body + "</p>";
            }
        }
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        for (AlerteBlocageProfil alerteBlocageProfil : blocageProfilList) {
            alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(true));
        }
        return blocageProfilList;
    }

    public List<Lienprivilege> EnvoyerLiensPrivileges(List<Lienprivilege> missions) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            String subject = "Validation de lien privil\u00e8ge Speakyfree sur Notre Continent";
            helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
            helper.setSubject(subject);
            for (Lienprivilege mission : missions) {
                String body = "<p>Bonjour,</p>";
                body = body + "<p>Votre lien Privil\u00e8ge a \u00e9t\u00e9 valid\u00e9. Vous pouvez d\u00e8s maintenant partager ce lien dans tous les groupes et r\u00e9seaux sociaux ou commentaires.</p>";
                body = body + "<p>A chaque cr\u00e9ation de compte avec ce lien, vous gagnerez 10 points qui augmenteront vos revenus.</p>";
                String lien = "<a href=\"" + mission.getLienprivilege() + "\" >" + mission.getLienprivilege() + "</a>";
                body = body + "<p>" + lien + "</p>";
                helper.setText(body, true);
                helper.setTo(mission.getCompte());
                try {
                    this.mailSender.send(message);
                    mission.setEstenvoyer(Boolean.valueOf(true));
                    mission.setDateenvoi(new Date());
                    mission.setStatus("Accept\u00e9");
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    this.bugsCronService.SaveBugCron("cron d'envoi du lien privil\u00e8ge par email \u00e0" + mission.getCompte(), e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.bugsCronService.SaveBugCron("cron d'envoi de liens privil\u00e8ges par email", e.getMessage());
        }
        return missions;
    }

    public String sendEnvoiCodeSMSCreationCompte(String numero, String canal) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un utilisateur vient de faire une tentative d'envoi de code " + canal + " de cr\u00e9ation de compte sur " + "https://dev.speakyfree.com" + " .</p>";
        body = body + "<br>";
        body = body + "<span>--> Num\u00e9ro de t\u00e9l\u00e9phone: " + numero + "</span>";
        String subject = "Nouvel envoi de code " + canal + " de cr\u00e9ation de compte";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendEnvoiCodeSMSResetPwd(String numero) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un utilisateur vient de faire une tentative d'envoi de code SMS de r\u00e9initialisation de mot de passe sur https://dev.speakyfree.com .</p>";
        body = body + "<br>";
        body = body + "<span>--> Num\u00e9ro de t\u00e9l\u00e9phone: " + numero + "</span>";
        String subject = "Nouvel envoi de code SMS de r\u00e9initialisation de mot de passe";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("dispatching.speaky@epsinium.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }
}

