/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsAmiService {
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private BugsCronService bugsCronService;

    @Transactional
    public void updatePointsCumules() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty()) continue;
                    Long pointscumules = 0L;
                    for (PointsAmi p : pointsAmis) {
                        pointscumules = pointscumules + p.getNbPointsMois();
                    }
                    ami.setTotalPointsCumules(pointscumules);
                }
                this.auteurRepository.saveAll((Iterable)amis);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points cumul\u00e9s des comptes amis", e.getMessage());
        }
    }

    @Transactional
    public void updatePointsarticleslus() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationList = this.recommandationRepository.findByEstcliquerAndAuteuridAndFraude(Boolean.valueOf(true), ami.getId(), Boolean.valueOf(false))).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandations = recommandationList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateClick()))).collect(Collectors.toList());
                        if (recommandations.isEmpty()) continue;
                        p.setNbArticlesLus(Long.valueOf(recommandations.size()));
                        p.setNbPointsArticlesLus(Long.valueOf(2L * p.getNbArticlesLus()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points des articles lus des comptes amis", e.getMessage());
        }
    }

    @Transactional
    public void updaterecommandationsaunami() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationAunAmisList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationAunAmisList = this.recommandationAunAmiRepository.findByAmiIDAndEstenvoyerOrderByDateenvoiDesc(ami.getId(), Boolean.valueOf(true))).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandationAunAmis = recommandationAunAmisList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateCreation()))).collect(Collectors.toList());
                        if (recommandationAunAmis.isEmpty()) continue;
                        p.setNbRecommandations(Long.valueOf(recommandationAunAmis.size()));
                        p.setNbPointsRecommandations(Long.valueOf(5L * p.getNbRecommandations()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points 'Recommandations \u00e0 un ami' des comptes amis", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="30 5 4 1 * *", zone="GMT")
    public void MAJPointsarticleslus() {
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String lastmois = dateFormat.format(dateelastmonth);
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List recommandations;
                    List recommandationList;
                    if (ami.getMonetisation() == null || !ami.getMonetisation().equals("Oui") || (recommandationList = this.recommandationRepository.findByEstcliquerAndAuteuridAndFraude(Boolean.valueOf(true), ami.getId(), Boolean.valueOf(false))).isEmpty() || (recommandations = recommandationList.stream().filter(r -> lastmois.equals(dateFormat.format(r.getDateClick()))).collect(Collectors.toList())).isEmpty()) continue;
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(lastmois, ami.getId());
                    if (pointsAmi != null) {
                        pointsAmi.setNbArticlesLus(Long.valueOf(recommandations.size()));
                        pointsAmi.setNbPointsArticlesLus(Long.valueOf((long)recommandations.size() * 2L));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + pointsAmi.getNbPointsRecommandations() + pointsAmi.getNbPointsMissions()));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                        continue;
                    }
                    PointsAmi p = new PointsAmi();
                    p.setNbArticlesLus(Long.valueOf(recommandations.size()));
                    p.setNbPointsArticlesLus(Long.valueOf(2L * (long)recommandations.size()));
                    p.setMois(lastmois);
                    p.setAmiId(ami.getId());
                    p.setNbPointsMissions(Long.valueOf(0L));
                    p.setNbMissions(Long.valueOf(0L));
                    p.setNbRecommandations(Long.valueOf(0L));
                    p.setNbPointsRecommandations(Long.valueOf(0L));
                    p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    this.pointsAmiRepository.save((Object)p);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points des articles lus des comptes amis", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="15 0 4 1 * *", zone="GMT")
    public void MAJPointsrecomsaunami() {
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String lastmois = dateFormat.format(dateelastmonth);
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List recommandationAunAmis;
                    List recommandationAunAmisList;
                    if (ami.getMonetisation() == null || !ami.getMonetisation().equals("Oui") || (recommandationAunAmisList = this.recommandationAunAmiRepository.findByAmiIDAndEstenvoyerOrderByDateenvoiDesc(ami.getId(), Boolean.valueOf(true))).isEmpty() || (recommandationAunAmis = recommandationAunAmisList.stream().filter(r -> lastmois.equals(dateFormat.format(r.getDateenvoi()))).collect(Collectors.toList())).isEmpty()) continue;
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(lastmois, ami.getId());
                    if (pointsAmi != null) {
                        pointsAmi.setNbRecommandations(Long.valueOf(recommandationAunAmis.size()));
                        pointsAmi.setNbPointsRecommandations(Long.valueOf((long)recommandationAunAmis.size() * 5L));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + pointsAmi.getNbPointsRecommandations() + pointsAmi.getNbPointsMissions()));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                        continue;
                    }
                    PointsAmi p = new PointsAmi();
                    p.setNbRecommandations(Long.valueOf(recommandationAunAmis.size()));
                    p.setNbPointsRecommandations(Long.valueOf(5L * (long)recommandationAunAmis.size()));
                    p.setMois(lastmois);
                    p.setAmiId(ami.getId());
                    p.setNbPointsMissions(Long.valueOf(0L));
                    p.setNbMissions(Long.valueOf(0L));
                    p.setNbArticlesLus(Long.valueOf(0L));
                    p.setNbPointsArticlesLus(Long.valueOf(0L));
                    p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    this.pointsAmiRepository.save((Object)p);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points 'Recommandations \u00e0 un ami' des comptes amis", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="30 25 4 1 * *", zone="GMT")
    public void MAJPointsCumules() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List pointsAmis;
                    if (ami.getMonetisation() == null || !ami.getMonetisation().equals("Oui") || (pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId())).isEmpty()) continue;
                    Long pointscumules = 0L;
                    for (PointsAmi p : pointsAmis) {
                        pointscumules = pointscumules + p.getNbPointsMois();
                    }
                    ami.setTotalPointsCumules(pointscumules);
                }
                this.auteurRepository.saveAll((Iterable)amis);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points cumul\u00e9s des comptes amis", e.getMessage());
        }
    }
}

