/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.ArticlesAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDtoWithPages;
import com.notrecontinent.webapi.LesDTOs.AuteurPwdDTO;
import com.notrecontinent.webapi.LesDTOs.AuteurPwdDTOWithPages;
import com.notrecontinent.webapi.LesDTOs.BugDTO;
import com.notrecontinent.webapi.LesDTOs.ConnexionAdminDTO;
import com.notrecontinent.webapi.LesDTOs.RecommandationAdminDTO;
import com.notrecontinent.webapi.LesDTOs.StatistiqueArticleDTO;
import com.notrecontinent.webapi.LesDTOs.StatistiquesArticle;
import com.notrecontinent.webapi.dto.ArticleWpDesactiver;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.CompteASupprimer;
import com.notrecontinent.webapi.entities.Connexion;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.ModePaiement;
import com.notrecontinent.webapi.entities.MonCompte;
import com.notrecontinent.webapi.entities.PaiementAdmin;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.PointsLienPrivilege;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.mapstruct.AuteurMapper;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.mapstruct.TransactionMapper;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.BugRepository;
import com.notrecontinent.webapi.repositories.CompteASupprimerRepository;
import com.notrecontinent.webapi.repositories.ComptesLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.repositories.FusionCompteWPSpeakyRepository;
import com.notrecontinent.webapi.repositories.LienprivilegeRepository;
import com.notrecontinent.webapi.repositories.ModePaiementRepository;
import com.notrecontinent.webapi.repositories.MonCompteRepository;
import com.notrecontinent.webapi.repositories.MonsupportRepository;
import com.notrecontinent.webapi.repositories.NotificationSmsRepository;
import com.notrecontinent.webapi.repositories.PaiementAdminRepository;
import com.notrecontinent.webapi.repositories.PaiementRepository;
import com.notrecontinent.webapi.repositories.PointLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.repositories.StatistiqueRepository;
import com.notrecontinent.webapi.repositories.TransactionRepository;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.security.services.UserDetailsServiceImpl;
import com.notrecontinent.webapi.services.ArticleService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdminService {
    @Value(value="${parametre.ref.interne}")
    private Long ref;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private BugRepository bugRepository;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private ArticleService articleService;
    @Autowired
    private AuteurMapper auteurMapper;
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private CompteASupprimerRepository compteASupprimerRepository;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private PaiementRepository paiementRepository;
    @Autowired
    private WhatsappService whatsappService;
    @Autowired
    private ModePaiementRepository modePaiementRepository;
    @Autowired
    private StatistiqueRepository statistiqueRepository;
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private MonCompteRepository monCompteRepository;
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private PaiementAdminRepository paiementAdminRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TransactionMapper transactionMapper;
    @Autowired
    private FusionCompteWPSpeakyRepository fusionCompteWPSpeakyRepository;
    @Autowired
    private PointLienPrivilegeRepository pointLienPrivilegeRepository;
    @Autowired
    private ComptesLienPrivilegeRepository comptesLienPrivilegeRepository;
    @Autowired
    private NotificationSmsRepository notificationSmsRepository;
    @Autowired
    private MonsupportRepository monsupportRepository;
    @Autowired
    private LienprivilegeRepository lienprivilegeRepository;
    @Autowired
    JwtUtils jwtUtils;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseEntity<ConnexionAdminDTO> getAllConnexion(int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page connexions = this.connexionRepository.findByOrderByDateConnexionDesc((Pageable)pageRequest);
        ConnexionAdminDTO connexionAdminDTO = new ConnexionAdminDTO();
        List connexionList = connexions.getContent();
        if (!connexionList.isEmpty()) {
            connexionAdminDTO.setConnexions(connexionList);
            connexionAdminDTO.setTotalPages(connexions.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)connexionAdminDTO).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)connexionAdminDTO);
    }

    public ResponseEntity<ConnexionAdminDTO> rechercherConnexion(String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page connexions = this.connexionRepository.findByUsernameContainingIgnoreCaseOrderByDateConnexionDesc(rech, (Pageable)pageRequest);
        ConnexionAdminDTO connexionAdminDTO = new ConnexionAdminDTO();
        List connexionList = connexions.getContent();
        if (!connexionList.isEmpty()) {
            connexionAdminDTO.setConnexions(connexionList);
            connexionAdminDTO.setTotalPages(connexions.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)connexionAdminDTO).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)connexionAdminDTO);
    }

    @Transactional
    public String Deconnexion(Long idconnexion) throws ParseException {
        Connexion connexion = (Connexion)this.connexionRepository.findById((Object)idconnexion).get();
        connexion.setFinSession(new Date());
        this.connexionRepository.save((Object)connexion);
        return "D\u00e9connexion r\u00e9ussie";
    }

    @Transactional
    public ResponseEntity<List<ArticlesAdminDto>> getAllArticles() throws IOException {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("Validation en cours");
        statusList.add("Valid\u00e9 (en ligne)");
        statusList.add("Rejet\u00e9");
        List articles = this.articleRepository.findByStatusInOrderByDateCreationDesc(statusList);
        ArrayList<ArticlesAdminDto> articlesAdmin = new ArrayList<ArticlesAdminDto>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                ArticlesAdminDto articleAdmin = new ArticlesAdminDto();
                articleAdmin.setArticleid(article.getId());
                articleAdmin.setLien(article.getLink());
                articleAdmin.setTitre(article.getTitre());
                articleAdmin.setCategorie(article.getCategorie());
                articleAdmin.setDatecreation(article.getDateCreation());
                articleAdmin.setStatus(article.getStatus());
                articleAdmin.setChecked(Boolean.valueOf(false));
                articleAdmin.setAuteurname(((Auteur)this.auteurRepository.findById((Object)article.getAuteurID()).get()).getName());
                articlesAdmin.add(articleAdmin);
            }
        }
        long contentLength = this.mapper.writeValueAsString(articlesAdmin).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(articlesAdmin);
    }

    @Transactional
    public String DeactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = article1.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            article1.setLastStatus(article1.getStatus());
            article1.setAdesactiver(Boolean.valueOf(true));
            article1.setStatus("Rejet\u00e9");
            article1.setDatemodification(new Date());
            this.articleRepository.save((Object)article1);
        }
        return "Article d\u00e9sactiv\u00e9";
    }

    @Transactional
    public String DeactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            }
            for (Article article : articles) {
                article.setLastStatus(article.getStatus());
                article.setAdesactiver(Boolean.valueOf(true));
                article.setStatus("Rejet\u00e9");
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles d\u00e9sactiv\u00e9s";
    }

    @Transactional
    public String ReactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            article1.setAreactiver(Boolean.valueOf(true));
            article1.setDatemodification(new Date());
            article1.setStatus(article1.getLastStatus());
            this.articleRepository.save((Object)article1);
        }
        return "Article r\u00e9activ\u00e9";
    }

    @Transactional
    public String ReactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                article.setAreactiver(Boolean.valueOf(true));
                article.setStatus(article.getLastStatus());
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles r\u00e9activ\u00e9s";
    }

    @Transactional
    public void DeactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAdesactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                articleWpDesactiver.setStatus("pending");
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAdesactiver(Boolean.valueOf(false));
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    @Transactional
    public void ReactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAreactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                switch (article.getLastStatus()) {
                    case "Validation en cours": {
                        articleWpDesactiver.setStatus("draft");
                        break;
                    }
                    case "Valid\u00e9 (en ligne)": {
                        articleWpDesactiver.setStatus("publish");
                    }
                }
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAreactiver(Boolean.valueOf(false));
                article.setStatus(article.getLastStatus());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    public ResponseEntity<List<AuteurAdminDto>> getAllAuteur() throws JsonProcessingException {
        List auteurs = this.auteurRepository.findByAsupprimerOrAsupprimerIsNullOrderByDateCreationDesc(Boolean.valueOf(false));
        List auteurAdminDtos = new ArrayList();
        if (!auteurs.isEmpty()) {
            Lienprivilege lienprivilege;
            auteurAdminDtos = this.auteurMapper.AuteursToAuteurAdminDtos(auteurs);
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                lienprivilege = this.lienprivilegeRepository.findByAuteurid(auteur.getId());
                if (lienprivilege == null) continue;
                auteur.setValidationlienprivilege(lienprivilege.getLienprivilege());
                if (lienprivilege.getStatus() == null || !lienprivilege.getStatus().equals("Accept\u00e9")) continue;
                auteur.setLienprivilegevalider(Boolean.valueOf(true));
            }
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                if (auteur.getParamlienprivilege() == null || (lienprivilege = this.lienprivilegeRepository.findByParametre(auteur.getParamlienprivilege())) == null) continue;
                auteur.setLienprivilege(lienprivilege.getLienprivilege());
            }
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(auteur.getId());
                if (modePaiement == null || !modePaiement.getMode().equals("Wallet")) continue;
                auteur.setTelpaiement(modePaiement.getNumero());
            }
        }
        long contentLength = this.mapper.writeValueAsString(auteurAdminDtos).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(auteurAdminDtos);
    }

    public ResponseEntity<AuteurAdminDtoWithPages> RechercherAuteur(String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page auteurPage = this.auteurRepository.findByUsernameContainingIgnoreCaseOrNameContainingIgnoreCaseOrTelephoneContainingIgnoreCaseOrNumwhatsappContainingIgnoreCaseOrderByDateCreationDesc(rech, rech, rech, rech, (Pageable)pageRequest);
        List auteurs = auteurPage.getContent();
        List auteurAdminDtos = new ArrayList();
        AuteurAdminDtoWithPages auteurAdminDtoWithPages = new AuteurAdminDtoWithPages();
        if (!auteurs.isEmpty()) {
            Lienprivilege lienprivilege;
            auteurAdminDtos = this.auteurMapper.AuteursToAuteurAdminDtos(auteurs);
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                lienprivilege = this.lienprivilegeRepository.findByAuteurid(auteur.getId());
                if (lienprivilege == null) continue;
                auteur.setValidationlienprivilege(lienprivilege.getLienprivilege());
                if (lienprivilege.getStatus() == null || !lienprivilege.getStatus().equals("Accept\u00e9")) continue;
                auteur.setLienprivilegevalider(Boolean.valueOf(true));
            }
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                if (auteur.getParamlienprivilege() == null || (lienprivilege = this.lienprivilegeRepository.findByParametre(auteur.getParamlienprivilege())) == null) continue;
                auteur.setLienprivilege(lienprivilege.getLienprivilege());
            }
            for (AuteurAdminDto auteur : auteurAdminDtos) {
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(auteur.getId());
                if (modePaiement == null || !modePaiement.getMode().equals("Wallet")) continue;
                auteur.setTelpaiement(modePaiement.getNumero());
            }
            auteurAdminDtoWithPages.setAuteurAdminDtos(auteurAdminDtos);
            auteurAdminDtoWithPages.setTotalPages(auteurPage.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)auteurAdminDtoWithPages).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteurAdminDtoWithPages);
    }

    public String generateRandomString(int length) {
        String SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".length());
            char randomChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    @Transactional
    public Auteur CreateAuteur(Auteur auteur) {
        Boolean b = this.auteurRepository.existsByUsernameAndBloquer(auteur.getUsername(), Boolean.valueOf(false));
        if (b.booleanValue()) {
            return null;
        }
        auteur.setEmail(auteur.getUsername() + "@notrecontinent.com");
        String pwd = this.bCryptPasswordEncoder.encode((CharSequence)auteur.getPassword());
        auteur.setPassword(pwd);
        auteur.setPays("S\u00e9n\u00e9gal");
        auteur.setCreerpar("t\u00e9l\u00e9phone");
        auteur.setRole("ami");
        auteur.setTelephone(auteur.getUsername());
        auteur.setCountrycodetelephone("SN");
        auteur.setCountrycodewhatsapp("SN");
        auteur.setBloquer(Boolean.valueOf(false));
        auteur.setMailenvoyer(Boolean.valueOf(false));
        String pwdcontrol = this.generateRandomString(15);
        auteur.setPasswordcontrole(pwdcontrol);
        auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
        return (Auteur)this.auteurRepository.save((Object)auteur);
    }

    @Transactional
    public String UpdatePasswordAuteur(String id, String newpwd) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)newpwd);
            auteur1.setPassword(pwd);
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Mot de passe modifi\u00e9";
    }

    @Transactional
    public String Updatemonetisation(Long id, String etat) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setMonetisation(etat);
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            MonCompte monCompte = this.monCompteRepository.findByAuteurid(id);
            if (monCompte != null) {
                if (auteur1.getMonetisation().equals("Oui")) {
                    monCompte.setMonetisation(Boolean.valueOf(true));
                } else if (auteur1.getMonetisation().equals("Non")) {
                    monCompte.setMonetisation(Boolean.valueOf(false));
                }
                this.monCompteRepository.save((Object)monCompte);
            } else {
                MonCompte monCompte1 = new MonCompte();
                monCompte1.setAuteurid(id);
                if (auteur1.getMonetisation().equals("Oui")) {
                    monCompte1.setMonetisation(Boolean.valueOf(true));
                } else if (auteur1.getMonetisation().equals("Non")) {
                    monCompte1.setMonetisation(Boolean.valueOf(false));
                }
                this.monCompteRepository.save((Object)monCompte1);
            }
        }
        return "Mon\u00e9tisation mise \u00e0 jour";
    }

    @Transactional
    public String BloquerAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(true));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur bloqu\u00e9";
    }

    @Transactional
    public String ReactiverAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(false));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur r\u00e9activ\u00e9";
    }

    @Transactional
    public String BloquerAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(true));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs bloqu\u00e9s";
    }

    @Transactional
    public String ReactiverAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(false));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs r\u00e9activ\u00e9s";
    }

    @Transactional
    public String deleteCompte(Long id) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent() && !this.compteASupprimerRepository.existsByCompteID(id).booleanValue()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setAsupprimer(Boolean.valueOf(true));
            auteur1.setArepliquer(Boolean.valueOf(false));
            auteur1.setAmodifierWP(Boolean.valueOf(false));
            auteur1.setBloquer(Boolean.valueOf(true));
            CompteASupprimer compteASupprimer = new CompteASupprimer();
            compteASupprimer.setCompteID(id);
            compteASupprimer.setUsername(auteur1.getUsername());
            compteASupprimer.setAsupprimer(Boolean.valueOf(true));
            compteASupprimer.setRole(auteur1.getRole());
            this.compteASupprimerRepository.save((Object)compteASupprimer);
            this.auteurRepository.save((Object)auteur1);
        }
        return "Compte pr\u00eat \u00e0 \u00eatre supprim\u00e9";
    }

    @Transactional
    public void SupprimerAuteurWP() {
        List auteurs = this.auteurRepository.findByAsupprimer(Boolean.valueOf(true));
        if (!auteurs.isEmpty()) {
            String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
            String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";
            HttpHeaders header = new HttpHeaders();
            String authHeader = "";
            for (Auteur auteur : auteurs) {
                int statusCode;
                ResponseEntity response;
                String deleteUserUrl;
                HttpEntity requestEntity;
                CompteASupprimer compteASupprimer = this.compteASupprimerRepository.findByCompteID(auteur.getId());
                if (compteASupprimer == null) continue;
                if (auteur.getWordpressID() != null) {
                    System.out.println(auteur.getWordpressID());
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://sn.notrecontinent.com/wp/v2/users/";
                    try {
                        System.out.println("d\u00e9but de la suppression");
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        System.out.println("fin de la suppression");
                        statusCode = response.getStatusCodeValue();
                        System.out.println("status de la r\u00e9ponse : " + statusCode);
                        if (statusCode == 200) {
                            System.out.println("d\u00e9but compte SN wordpress supprim\u00e9");
                            auteur.setWordpressID(null);
                            compteASupprimer.setStatusSNwordpress("compte supprim\u00e9");
                            System.out.println("compte SN wordpress supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setWordpressID(null);
                            compteASupprimer.setStatusSNwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans SN Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMlWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ml.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMlWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setMlWordpressID(null);
                            compteASupprimer.setStatusMLwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setMlWordpressID(null);
                            compteASupprimer.setStatusMLwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans ML Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getGnWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://gn.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getGnWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setGnWordpressID(null);
                            compteASupprimer.setStatusGNwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setGnWordpressID(null);
                            compteASupprimer.setStatusGNwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans GN Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getGaWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ga.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getGaWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setGaWordpressID(null);
                            compteASupprimer.setStatusGAwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setGaWordpressID(null);
                            compteASupprimer.setStatusGAwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans GA Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getBjWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://bj.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getBjWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setBjWordpressID(null);
                            compteASupprimer.setStatusBJwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setBjWordpressID(null);
                            compteASupprimer.setStatusBJwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans BJ Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getBfWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://bf.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getBfWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setBfWordpressID(null);
                            compteASupprimer.setStatusBFwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setBfWordpressID(null);
                            compteASupprimer.setStatusBFwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans BF Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getNeWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ne.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getNeWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setNeWordpressID(null);
                            compteASupprimer.setStatusNEwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setNeWordpressID(null);
                            compteASupprimer.setStatusNEwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans NE Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCiWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ci.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCiWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setCiWordpressID(null);
                            compteASupprimer.setStatusCIwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setCiWordpressID(null);
                            compteASupprimer.setStatusCIwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans CI Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCdWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cd.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCdWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setCdWordpressID(null);
                            compteASupprimer.setStatusCDwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setCdWordpressID(null);
                            compteASupprimer.setStatusCDwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans CD Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCgWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setCgWordpressID(null);
                            compteASupprimer.setStatusCGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setCgWordpressID(null);
                            compteASupprimer.setStatusCGwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans CG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMrWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://mr.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMrWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setMrWordpressID(null);
                            compteASupprimer.setStatusMRwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setMrWordpressID(null);
                            compteASupprimer.setStatusMRwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans MR Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMgWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://mg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setMgWordpressID(null);
                            compteASupprimer.setStatusMGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setMgWordpressID(null);
                            compteASupprimer.setStatusMGwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans MG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getTgWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://tg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getTgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setTgWordpressID(null);
                            compteASupprimer.setStatusTGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setTgWordpressID(null);
                            compteASupprimer.setStatusTGwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans TG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getFrWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://fr.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getFrWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setFrWordpressID(null);
                            compteASupprimer.setStatusFRwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setFrWordpressID(null);
                            compteASupprimer.setStatusFRwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans FR Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCaWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ca.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCaWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setCaWordpressID(null);
                            compteASupprimer.setStatusCAwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setCaWordpressID(null);
                            compteASupprimer.setStatusCAwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans CA Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCmWordpressID() != null) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cm.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCmWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            auteur.setCmWordpressID(null);
                            compteASupprimer.setStatusCMwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            auteur.setCmWordpressID(null);
                            compteASupprimer.setStatusCMwordpress("le compte n'existe pas");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte " + compteASupprimer.getUsername() + " dans CM Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                this.compteASupprimerRepository.save((Object)compteASupprimer);
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    public void SupprimerAuteursSpeakyfree() throws IOException {
        List compteASupprimers = this.compteASupprimerRepository.findByAsupprimer(Boolean.valueOf(true));
        if (!compteASupprimers.isEmpty()) {
            String CS = "compte supprim\u00e9";
            String CEP = "le compte n'existe pas";
            for (CompteASupprimer c : compteASupprimers) {
                try {
                    Boolean b = false;
                    if (c.getRole().equals("ami")) {
                        b = true;
                    } else if (c.getRole().equals("contributeur")) {
                        b = !(!c.getStatusSNwordpress().equals(CS) && !c.getStatusSNwordpress().equals(CEP) || !c.getStatusGNwordpress().equals(CS) && !c.getStatusGNwordpress().equals(CEP) || !c.getStatusBFwordpress().equals(CS) && !c.getStatusBFwordpress().equals(CEP) || !c.getStatusCDwordpress().equals(CS) && !c.getStatusCDwordpress().equals(CEP) || !c.getStatusCAwordpress().equals(CS) && !c.getStatusCAwordpress().equals(CEP) || !c.getStatusBJwordpress().equals(CS) && !c.getStatusBJwordpress().equals(CEP) || !c.getStatusCGwordpress().equals(CS) && !c.getStatusCGwordpress().equals(CEP) || !c.getStatusCIwordpress().equals(CS) && !c.getStatusCIwordpress().equals(CEP) || !c.getStatusCMwordpress().equals(CS) && !c.getStatusCMwordpress().equals(CEP) || !c.getStatusFRwordpress().equals(CS) && !c.getStatusFRwordpress().equals(CEP) || !c.getStatusGAwordpress().equals(CS) && !c.getStatusGAwordpress().equals(CEP) || !c.getStatusMGwordpress().equals(CS) && !c.getStatusMGwordpress().equals(CEP) || !c.getStatusMLwordpress().equals(CS) && !c.getStatusMLwordpress().equals(CEP) || !c.getStatusMRwordpress().equals(CS) && !c.getStatusMRwordpress().equals(CEP) || !c.getStatusNEwordpress().equals(CS) && !c.getStatusNEwordpress().equals(CEP) || !c.getStatusTGwordpress().equals(CS) && !c.getStatusTGwordpress().equals(CEP));
                    }
                    if (!b.booleanValue()) continue;
                    this.connexionRepository.deleteByUsername(c.getUsername());
                    Optional auteur = this.auteurRepository.findById((Object)c.getCompteID());
                    if (auteur.isPresent()) {
                        if (((Auteur)auteur.get()).getPiece() != null && !Objects.equals(((Auteur)auteur.get()).getPiece(), "")) {
                            this.photoService.deletePhotoIdentite(((Auteur)auteur.get()).getPiece());
                        }
                        if (((Auteur)auteur.get()).getAutrepiece() != null && !Objects.equals(((Auteur)auteur.get()).getAutrepiece(), "")) {
                            this.photoService.deletePhotoIdentite(((Auteur)auteur.get()).getAutrepiece());
                        }
                        this.fusionCompteWPSpeakyRepository.deleteByUsername(((Auteur)auteur.get()).getUsername());
                        if (((Auteur)auteur.get()).getRole().equals("ami")) {
                            ((Auteur)auteur.get()).setCentresdinterets(new ArrayList());
                            this.auteurRepository.save(auteur.get());
                        }
                    }
                    this.lienprivilegeRepository.deleteByAuteurid(c.getCompteID());
                    this.monCompteRepository.deleteByAuteurid(c.getCompteID());
                    this.monsupportRepository.deleteByIdcompte(c.getCompteID());
                    this.pointLienPrivilegeRepository.deleteByAuteurid(c.getCompteID());
                    this.comptesLienPrivilegeRepository.deleteByIdcompteproplien(c.getCompteID());
                    this.modePaiementRepository.deleteByAuteurID(c.getCompteID());
                    this.paiementRepository.deleteByAuteurID(c.getCompteID());
                    if (c.getRole().equals("contributeur")) {
                        List idsArticles = this.articleRepository.findIdByAuteurID(c.getCompteID());
                        if (!idsArticles.isEmpty()) {
                            this.articleService.deleteArticles(idsArticles);
                        }
                        this.pointsContributeurRepository.deleteByContributeurid(c.getCompteID());
                    } else if (c.getRole().equals("ami")) {
                        this.recommandationRepository.deleteByAuteurid(c.getCompteID());
                        this.recommandationAunAmiRepository.deleteByAmiID(c.getCompteID());
                        this.pointsAmiRepository.deleteByAmiId(c.getCompteID());
                        this.notificationSmsRepository.deleteByAmiid(c.getCompteID());
                    }
                    this.auteurRepository.deleteById((Object)c.getCompteID());
                    c.setAsupprimer(Boolean.valueOf(false));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println(e.getLocalizedMessage());
                    this.bugsCronService.SaveBugCron("Suppression compte " + c.getUsername() + " dans Speakyfree", e.getMessage() + "\n" + e.getLocalizedMessage());
                }
            }
            this.compteASupprimerRepository.saveAll((Iterable)compteASupprimers);
        }
    }

    @Transactional
    public UserInfoResponse SeConnecterAuCompteAuteur(String username, String pwd) {
        Auteur auteur = this.auteurRepository.findByUsername(username);
        if (auteur == null) {
            return null;
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        String token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), auteur.getId());
        Date date = new Date();
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
        if (con == null) {
            Connexion connexion = new Connexion();
            connexion.setUsername(username.toLowerCase());
            connexion.setToken(token);
            connexion.setDebutSession(date);
            connexion.setResultat("Connect\u00e9");
            connexion.setDateConnexion(date);
            connexion.setBug(Boolean.valueOf(false));
            Connexion connexion1 = (Connexion)this.connexionRepository.save((Object)connexion);
            userInfoResponse = new UserInfoResponse(token, auteur, 86400000, connexion1.getId());
        } else {
            userInfoResponse = new UserInfoResponse(token, auteur, 86400000, con.getId());
        }
        return userInfoResponse;
    }

    public ResponseEntity<AuteurPwdDTOWithPages> getAllAuteurPwdDtos(int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page page = this.auteurRepository.findByAsupprimerOrAsupprimerIsNullOrderByDateCreationDesc(Boolean.valueOf(false), (Pageable)pageRequest);
        List auteurs = page.getContent();
        AuteurPwdDTOWithPages auteurPwdDTOWithPages = new AuteurPwdDTOWithPages();
        if (!auteurs.isEmpty() && !(auteurs = auteurs.stream().filter(a -> !a.getRole().equals("admin")).collect(Collectors.toList())).isEmpty()) {
            List auteurPwdDTOS = this.auteurMapper.AuteursToAuteurPwdDTO(auteurs);
            for (AuteurPwdDTO auteur : auteurPwdDTOS) {
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(auteur.getId());
                if (modePaiement == null || !modePaiement.getMode().equals("Wallet")) continue;
                auteur.setTelpaiement(modePaiement.getNumero());
            }
            auteurPwdDTOWithPages.setAuteurPwdDTOS(auteurPwdDTOS);
            auteurPwdDTOWithPages.setTotalPages(page.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)auteurPwdDTOWithPages).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteurPwdDTOWithPages);
    }

    public ResponseEntity<AuteurPwdDTOWithPages> RechercherAuteurPwdDtos(String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page page = this.auteurRepository.findByUsernameContainingIgnoreCaseOrNameContainingIgnoreCaseOrTelephoneContainingIgnoreCaseOrNumwhatsappContainingIgnoreCaseOrderByDateCreationDesc(rech, rech, rech, rech, (Pageable)pageRequest);
        List auteurs = page.getContent();
        AuteurPwdDTOWithPages auteurPwdDTOWithPages = new AuteurPwdDTOWithPages();
        if (!auteurs.isEmpty() && !(auteurs = auteurs.stream().filter(a -> !a.getRole().equals("admin")).collect(Collectors.toList())).isEmpty()) {
            List auteurPwdDTOS = this.auteurMapper.AuteursToAuteurPwdDTO(auteurs);
            for (AuteurPwdDTO auteur : auteurPwdDTOS) {
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(auteur.getId());
                if (modePaiement == null || !modePaiement.getMode().equals("Wallet")) continue;
                auteur.setTelpaiement(modePaiement.getNumero());
            }
            auteurPwdDTOWithPages.setAuteurPwdDTOS(auteurPwdDTOS);
            auteurPwdDTOWithPages.setTotalPages(page.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)auteurPwdDTOWithPages).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteurPwdDTOWithPages);
    }

    public ResponseEntity<List<DashbordStats>> getAdminDashboardStats() throws JsonProcessingException {
        List articles = this.articleRepository.findAll();
        ArrayList<DashbordStats> dashbordStats = new ArrayList<DashbordStats>();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        if (!articles.isEmpty()) {
            for (int i = 0; i < articles.size(); ++i) {
                DashbordStats dashbordStats1 = new DashbordStats(((Article)articles.get(i)).getStatus(), format.format(((Article)articles.get(i)).getDateCreation()));
                dashbordStats.add(dashbordStats1);
            }
        }
        long contentLength = this.mapper.writeValueAsString(dashbordStats).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(dashbordStats);
    }

    @Transactional
    public ResponseEntity<StatistiqueArticleDTO> getAdminStatistiques(int pageNumber) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page articlesPage = this.articleRepository.findByStatusOrderByDateCreationDesc("Valid\u00e9 (en ligne)", (Pageable)pageRequest);
        StatistiqueArticleDTO statistiqueArticleDTO = new StatistiqueArticleDTO();
        List articles = articlesPage.getContent();
        ArrayList<StatistiquesArticle> statistiquesArticles = new ArrayList<StatistiquesArticle>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                StatistiquesArticle s = new StatistiquesArticle();
                s.setLienarticle(article.getLink());
                s.setTitrearticle(article.getTitre());
                s.setCategorie(article.getCategorie());
                s.setDateCreation(article.getDateCreation());
                s.setPageViews(article.getPageViews());
                s.setDateDerniereVue(article.getDateDerniereVue());
                statistiquesArticles.add(s);
            }
            statistiqueArticleDTO.setStatistiquesArticles(statistiquesArticles);
            statistiqueArticleDTO.setTotalPages(articlesPage.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)statistiqueArticleDTO).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)statistiqueArticleDTO);
    }

    public ResponseEntity<StatistiqueArticleDTO> RechercherArticlesStatistiques(String rech, int pageNumber) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page articlesPage = this.articleRepository.RechercherArticleStatistiqueOrderByDateCreationDesc("Valid\u00e9 (en ligne)", rech, (Pageable)pageRequest);
        StatistiqueArticleDTO statistiqueArticleDTO = new StatistiqueArticleDTO();
        List articles = articlesPage.getContent();
        ArrayList<StatistiquesArticle> statistiquesArticles = new ArrayList<StatistiquesArticle>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                StatistiquesArticle s = new StatistiquesArticle();
                s.setLienarticle(article.getLink());
                s.setTitrearticle(article.getTitre());
                s.setCategorie(article.getCategorie());
                s.setDateCreation(article.getDateCreation());
                s.setPageViews(article.getPageViews());
                s.setDateDerniereVue(article.getDateDerniereVue());
                statistiquesArticles.add(s);
            }
            statistiqueArticleDTO.setStatistiquesArticles(statistiquesArticles);
            statistiqueArticleDTO.setTotalPages(articlesPage.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)statistiqueArticleDTO).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)statistiqueArticleDTO);
    }

    @Transactional
    public ResponseEntity<BugDTO> getAllBugs(int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        Page page = this.bugRepository.findByOrderByDatebugDesc((Pageable)pageRequest);
        BugDTO bugDTO = new BugDTO();
        List bugs = page.getContent();
        if (!bugs.isEmpty()) {
            bugDTO.setBugs(bugs);
            bugDTO.setTotalPages(page.getTotalPages());
        }
        long contentLength = this.mapper.writeValueAsString((Object)bugDTO).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)bugDTO);
    }

    @Transactional
    public ResponseEntity<RecommandationAdminDTO> getAllRecommandations(int pageNumber) throws JsonProcessingException {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)20);
        Page page = this.recommandationRepository.findAllByOrderByDateCreationDesc((Pageable)pageable);
        List recommandations = page.getContent();
        if (!recommandations.isEmpty()) {
            List recommandationAdmins = this.recommandationMapper.RecommandationsToRecommandationAdmin(recommandations);
            RecommandationAdminDTO recommandationAdminDTO = new RecommandationAdminDTO();
            recommandationAdminDTO.setRecommandations(recommandationAdmins);
            recommandationAdminDTO.setTotalPages(page.getTotalPages());
            long contentLength = this.mapper.writeValueAsString((Object)recommandationAdminDTO).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAdminDTO);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> getAllPaiements() throws JsonProcessingException {
        List paiementAdmins = this.paiementAdminRepository.findAllByOrderByDateCreationDesc();
        if (!paiementAdmins.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> ajouterPaiementAdmin(PaiementAdmin paiementAdmin) throws JsonProcessingException {
        List paiementAdmins;
        PaiementAdmin paiementAdmin1 = this.paiementAdminRepository.findByMois(paiementAdmin.getMois());
        if (paiementAdmin1 == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            paiementAdmin.setEstconfirmer(Boolean.valueOf(false));
            this.paiementAdminRepository.save((Object)paiementAdmin);
            List auteurs = this.auteurRepository.findByMonetisationAndRoleIn("Oui", Arrays.asList("ami", "contributeur"));
            if (!auteurs.isEmpty()) {
                Transaction transaction;
                String moisprecedent = paiementAdmin.getMois();
                ArrayList<Auteur> amis = new ArrayList<Auteur>();
                ArrayList<Auteur> contributeurs = new ArrayList<Auteur>();
                ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
                for (Auteur a : auteurs) {
                    if (a.getRole().equals("ami")) {
                        amis.add(a);
                        continue;
                    }
                    if (!a.getRole().equals("contributeur")) continue;
                    contributeurs.add(a);
                }
                ArrayList pointsAmiList = new ArrayList();
                ArrayList pointsContributeurList = new ArrayList();
                if (!amis.isEmpty()) {
                    for (Auteur auteur : amis) {
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(moisprecedent, auteur.getId());
                        if (pointsAmi == null || pointsAmi.getNbPointsMois() <= 2L) continue;
                        transaction = new Transaction();
                        transaction.setAuteurid(auteur.getId());
                        transaction.setUsername(auteur.getUsername());
                        transaction.setPoints(pointsAmi.getNbPointsMois());
                        transaction.setMois(moisprecedent);
                        transaction.setMonetisation(auteur.getMonetisation());
                        transaction.setNom(auteur.getLast_name());
                        transaction.setPeriode(paiementAdmin.getPeriode());
                        transaction.setPrenom(auteur.getFirst_name());
                        transaction.setTypecompte(auteur.getRole());
                        transaction.setPaiementid(paiementAdmin.getId());
                        transaction.setEstconfirmer(Boolean.valueOf(false));
                        transaction.setEstpayer(Boolean.valueOf(false));
                        transaction.setSmsenvoyer(Boolean.valueOf(false));
                        transaction.setPaiementok(Boolean.valueOf(false));
                        transaction.setApayerplustardok(Boolean.valueOf(false));
                        transaction.setDateCreationCompte(auteur.getDateCreation());
                        transaction.setRefDigimp(auteur.getMatricule());
                        transaction.setCni(auteur.getNumeropiece());
                        transactionList.add(transaction);
                    }
                }
                if (!contributeurs.isEmpty()) {
                    for (Auteur auteur : contributeurs) {
                        List pointsContributeurs = this.pointsContributeurRepository.findByMoisAndContributeurid(moisprecedent, auteur.getId());
                        if (pointsContributeurs.isEmpty()) continue;
                        transaction = new Transaction();
                        transaction.setAuteurid(auteur.getId());
                        transaction.setUsername(auteur.getUsername());
                        transaction.setPoints(Long.valueOf(100L * (long)pointsContributeurs.size()));
                        transaction.setMois(moisprecedent);
                        transaction.setMonetisation(auteur.getMonetisation());
                        transaction.setNom(auteur.getLast_name());
                        transaction.setPeriode(paiementAdmin.getPeriode());
                        transaction.setPrenom(auteur.getFirst_name());
                        transaction.setTypecompte(auteur.getRole());
                        transaction.setPaiementid(paiementAdmin.getId());
                        transaction.setEstconfirmer(Boolean.valueOf(false));
                        transaction.setEstpayer(Boolean.valueOf(false));
                        transaction.setSmsenvoyer(Boolean.valueOf(false));
                        transaction.setPaiementok(Boolean.valueOf(false));
                        transaction.setApayerplustardok(Boolean.valueOf(false));
                        transaction.setDateCreationCompte(auteur.getDateCreation());
                        transaction.setRefDigimp(auteur.getMatricule());
                        transaction.setCni(auteur.getNumeropiece());
                        PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(auteur.getId(), moisprecedent);
                        if (pointsLienPrivilege != null) {
                            transaction.setPoints(Long.valueOf(transaction.getPoints() + pointsLienPrivilege.getNbPointsComptesCreer()));
                        }
                        transactionList.add(transaction);
                    }
                }
                if (!transactionList.isEmpty()) {
                    paiementAdmin.setNbmembres(Long.valueOf(transactionList.size()));
                    Long totalpoints = 0L;
                    for (Transaction t : transactionList) {
                        totalpoints = totalpoints + t.getPoints();
                    }
                    paiementAdmin.setPoints(totalpoints);
                    this.paiementAdminRepository.save((Object)paiementAdmin);
                    for (Transaction t : transactionList) {
                        ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(t.getAuteurid());
                        if (modePaiement != null) {
                            t.setTypepaiement(modePaiement.getMode().toLowerCase());
                            if (modePaiement.getMode().equals("Western Union")) {
                                t.setOperateur(modePaiement.getPrenomb() + " " + modePaiement.getNomb());
                                t.setDestinataire(modePaiement.getPaysdest());
                            } else if (modePaiement.getMode().equals("Wallet")) {
                                t.setDestinataire(modePaiement.getNumero().substring(3));
                                if (modePaiement.getOperateur().equals("Free Money S\u00e9n\u00e9gal")) {
                                    t.setOperateur("freemoney");
                                } else {
                                    t.setOperateur(modePaiement.getOperateur().toLowerCase());
                                }
                            }
                        }
                        Long montant = Math.round((float)(t.getPoints() * paiementAdmin.getBudget()) / (float)paiementAdmin.getPoints().longValue());
                        t.setMontantcalculer(montant);
                        t.setMontantapayer(montant);
                        List transactionsanterieurs = this.transactionRepository.findByAuteuridAndEstpayerAndPaiementidNot(t.getAuteurid(), Boolean.valueOf(false), t.getPaiementid());
                        if (transactionsanterieurs.isEmpty() || (transactionsanterieurs = transactionsanterieurs.stream().filter(tr -> {
                            try {
                                return dateFormat.parse(tr.getMois()).before(dateFormat.parse(moisprecedent));
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                        }).collect(Collectors.toList())).isEmpty()) continue;
                        Long revenusant = 0L;
                        for (Transaction tra : transactionsanterieurs) {
                            revenusant = revenusant + tra.getMontantapayer();
                        }
                        t.setRevenusanterieurs(revenusant);
                        t.setMontantapayer(Long.valueOf(t.getMontantapayer() + revenusant));
                    }
                    Transaction transaction2 = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
                    if (transaction2 != null) {
                        this.ref = transaction2.getParamref() + 1L;
                    }
                    for (Transaction t : transactionList) {
                        String refinterne = "NC" + this.ref;
                        t.setRefInterne(refinterne);
                        t.setParamref(this.ref);
                        this.ref = this.ref + 1L;
                    }
                    this.transactionRepository.saveAll(transactionList);
                }
            }
        }
        if (!(paiementAdmins = this.paiementAdminRepository.findAll()).isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<Transaction>> getTransactionsByPaiementAdmin(Long id) throws JsonProcessingException {
        List transactionList = this.transactionRepository.findByPaiementidOrderByIdDesc(id);
        if (!transactionList.isEmpty()) {
            for (Transaction t : transactionList) {
                Optional auteur;
                if (t.getAuteurid() == null) continue;
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(t.getAuteurid());
                if (modePaiement != null) {
                    t.setTypepaiement(modePaiement.getMode().toLowerCase());
                    if (modePaiement.getMode().equals("Western Union")) {
                        t.setOperateur(modePaiement.getPrenomb() + " " + modePaiement.getNomb());
                        t.setDestinataire(modePaiement.getPaysdest());
                    } else if (modePaiement.getMode().equals("Wallet")) {
                        t.setDestinataire(modePaiement.getNumero().substring(3));
                        if (modePaiement.getOperateur().equals("Free Money S\u00e9n\u00e9gal")) {
                            t.setOperateur("freemoney");
                        } else {
                            t.setOperateur(modePaiement.getOperateur().toLowerCase());
                        }
                    }
                }
                if (!(auteur = this.auteurRepository.findById((Object)t.getAuteurid())).isPresent()) continue;
                Auteur auteur1 = (Auteur)auteur.get();
                t.setUsername(auteur1.getUsername());
            }
            this.transactionRepository.saveAll((Iterable)transactionList);
            long contentLength = this.mapper.writeValueAsString((Object)transactionList).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)transactionList);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> UpdateBudget(PaiementAdmin paiementAdmin) throws JsonProcessingException {
        Transaction transaction;
        this.paiementAdminRepository.save((Object)paiementAdmin);
        List transactionList = this.transactionRepository.findByPaiementidOrderByIdDesc(paiementAdmin.getId());
        if (!transactionList.isEmpty()) {
            for (Transaction t : transactionList) {
                t.setEstpayer(Boolean.valueOf(false));
                Long montant = Math.round((float)(t.getPoints() * paiementAdmin.getBudget()) / (float)paiementAdmin.getPoints().longValue());
                t.setMontantcalculer(montant);
                t.setMontantapayer(montant);
                t.setMontantapayer(Long.valueOf(t.getMontantapayer() + t.getRevenusanterieurs()));
            }
        }
        if ((transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc()) != null) {
            this.ref = transaction.getParamref() + 1L;
        }
        for (Transaction t : transactionList) {
            if (t.getRefInterne() != null) continue;
            String refinterne = "NC" + this.ref;
            t.setRefInterne(refinterne);
            t.setParamref(this.ref);
            this.ref = this.ref + 1L;
        }
        this.transactionRepository.saveAll((Iterable)transactionList);
        List paiementAdmins = this.paiementAdminRepository.findAllByOrderByDateCreationDesc();
        if (!paiementAdmins.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public String UpdateMontantsTransactions(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                t.setEstpayer(Boolean.valueOf(false));
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
        }
        return "OK";
    }

    @Transactional
    public String ConfirmMontantsTransactions(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            for (Transaction transaction : transactionList) {
                transaction.setEstconfirmer(Boolean.valueOf(true));
            }
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
            PaiementAdmin paiementAdmin = (PaiementAdmin)this.paiementAdminRepository.findById((Object)transactionList.get(0).getPaiementid()).get();
            paiementAdmin.setEstconfirmer(Boolean.valueOf(true));
            this.paiementAdminRepository.save((Object)paiementAdmin);
        }
        return "OK";
    }

    @Transactional
    public String ConfirmMontantsDigimp(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            for (Transaction t : transactionList) {
                if (!t.getEstpayer().booleanValue() || t.getSmsenvoyer().booleanValue() || t.getDatepaiement() != null) continue;
                t.setDatepaiement(new Date());
            }
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
        }
        return "OK";
    }

    @Transactional
    public String DeletePaiement(Long id) {
        Optional paiementAdmin = this.paiementAdminRepository.findById((Object)id);
        if (paiementAdmin.isPresent()) {
            this.transactionRepository.deleteByPaiementid(id);
            this.paiementAdminRepository.deleteById((Object)id);
        }
        return "paiement supprim\u00e9";
    }

    private String generateRefInterne() {
        String refinterne = "NC" + this.ref;
        this.ref = this.ref + 1L;
        return refinterne;
    }

    @Transactional
    public void SendConfirmationPaiement() {
        List transactions = this.transactionRepository.findBySmsenvoyerAndEstconfirmerAndEstpayerAndTypepaiement(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), "wallet");
        if (!transactions.isEmpty()) {
            List auteursSN;
            String mois = ((Transaction)transactions.get(0)).getMois();
            long coeff = Math.round((float)((Transaction)transactions.get(0)).getMontantcalculer().longValue() / (float)((Transaction)transactions.get(0)).getPoints().longValue());
            HashSet<Long> ids = new HashSet<Long>();
            for (Transaction t : transactions) {
                ids.add(t.getAuteurid());
            }
            List auteurs = this.auteurRepository.findByIdIn(new ArrayList(ids));
            if (!auteurs.isEmpty() && !(auteursSN = auteurs.stream().filter(a -> a.getPays().equals("S\u00e9n\u00e9gal")).collect(Collectors.toList())).isEmpty()) {
                String token = this.smsService.getAuthToken().getToken();
                ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
                for (Transaction t : transactions) {
                    Auteur auteur = auteursSN.stream().filter(a -> Objects.equals(a.getId(), t.getAuteurid())).findFirst().get();
                    if (auteur.getBloquer().booleanValue()) continue;
                    if (auteur.getRole().equals("ami")) {
                        Transaction transaction;
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, auteur.getId());
                        if (pointsAmi == null) continue;
                        long nbclics = pointsAmi.getNbArticlesLus();
                        if (auteur.getNumwhatsapp() != null && !auteur.getNumwhatsapp().equals("") && auteur.getCode1234envoyer().booleanValue()) {
                            transaction = this.whatsappService.EnvoyerWhatsappConfirmationPaiement(auteur, t, nbclics);
                            transactionList.add(transaction);
                            continue;
                        }
                        transaction = this.smsService.EnvoyerSMSConfirmationPaiement(token, auteur, t, nbclics);
                        transactionList.add(transaction);
                        continue;
                    }
                    if (!auteur.getRole().equals("contributeur")) continue;
                    Transaction transaction = this.smsService.EnvoyerSMSConfirmationPaiement(token, auteur, t, coeff);
                    transactionList.add(transaction);
                }
                if (!transactionList.isEmpty()) {
                    this.transactionRepository.saveAll(transactionList);
                }
            }
        }
    }
}

