/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Bugs;
import com.notrecontinent.webapi.entities.CreationResetCompte;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.repositories.CreationResetCompteRepository;
import com.notrecontinent.webapi.services.BugService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.CodeWhatsappService;
import com.notrecontinent.webapi.services.MailService;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsappService {
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private CodeWhatsappService codeWhatsappService;
    @Autowired
    private MailService mailService;
    @Autowired
    private BugService bugService;
    @Autowired
    private CreationResetCompteRepository creationResetCompteRepository;

    @Transactional
    public String Sendcodevalidation(String numero) throws IOException, MessagingException {
        CreationResetCompte creationResetCompte = new CreationResetCompte();
        creationResetCompte.setType("cr\u00e9ation compte");
        creationResetCompte.setCanal("WhatsApp");
        creationResetCompte.setUsername(numero);
        this.creationResetCompteRepository.save((Object)creationResetCompte);
        String resp = this.codeWhatsappService.GenerercodeWhatsapp(numero, "cr\u00e9ation compte");
        return resp;
    }

    @Transactional
    public String Sendcodevalidationtelephone(String numero) throws IOException, MessagingException {
        String resp = this.codeWhatsappService.GenerercodeWhatsapp(numero, "validation t\u00e9l\u00e9phone");
        try {
            this.mailService.sendEnvoiCodeSMSCreationCompte(numero, "Whatsapp");
        }
        catch (Exception e) {
            Bugs bugs = new Bugs();
            bugs.setCompte(numero);
            bugs.setDetails("envoi de l'alerte email lors de l'envoi du code Whatsapp de validation de t\u00e9l\u00e9phone. " + e.getMessage());
            this.bugService.SaveBug(bugs);
        }
        return resp;
    }

    @Transactional
    public String Sendcodereset(String numero) throws IOException, MessagingException {
        String resp = this.codeWhatsappService.GenerercodeResetWhatsapp(numero, "r\u00e9initialisation de mot de passe");
        try {
            this.mailService.sendEnvoiCodeSMSCreationCompte(numero, "SMS");
        }
        catch (Exception e) {
            Bugs bugs = new Bugs();
            bugs.setCompte(numero);
            bugs.setDetails("envoi de l'alerte email lors de l'envoi du code Whatsapp de r\u00e9initialisation de mot de passe. " + e.getMessage());
            this.bugService.SaveBug(bugs);
        }
        return resp;
    }

    public List<Long> envoyerAlertesfraudesclicrecommandations(List<List<String>> numeroswhatsapp) {
        ArrayList<Long> idsamis = new ArrayList<Long>();
        OkHttpClient client = new OkHttpClient();
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
        for (List<String> numerowhatsapp : numeroswhatsapp) {
            String message = salutation + numerowhatsapp.get(2) + ",\n\n";
            message = message + "Il est interdit de cliquer sur 3 articles en moins de 2 minutes. Nous vous recommandons de lire les articles en prenant votre temps entre chaque clic sur une nouvelle notification afin d'\u00e9viter d'avoir des rejets.\n\n";
            message = message + "*IMPORTANT*: Ne pas r\u00e9pondre \u00e0 ce message sur ce num\u00e9ro c'est un chatbot ou robot qui vous r\u00e9pond. Si vous souhaitez entrer en contact avec NOTRE CONTINENT, appeler ou envoyer un message sur le num\u00e9ro suivant : +221 78 888 1134";
            FormBody body = new FormBody.Builder().add("token", "dx0avb93wryxyd4f").add("to", "+" + numerowhatsapp.get(1)).add("body", message).build();
            Request request = new Request.Builder().url("https://api.ultramsg.com/instance75373/messages/chat").post((RequestBody)body).addHeader("content-type", "application/x-www-form-urlencoded").build();
            Response response = null;
            try {
                response = client.newCall(request).execute();
                idsamis.add(Long.valueOf(numerowhatsapp.get(0)));
                System.out.println(response.body().string());
                System.out.println("alerte fraude recommandation envoy\u00e9e");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                this.bugsCronService.SaveBugCron("cron d'envoi alerte fraude clics par whatsapp \u00e0" + numerowhatsapp.get(1) + " d'id : " + numerowhatsapp.get(0), e.getMessage());
            }
        }
        return idsamis;
    }

    public List<Lienprivilege> EnvoyerLiensPrivileges(List<Lienprivilege> missions) {
        OkHttpClient client = new OkHttpClient();
        for (Lienprivilege mission : missions) {
            String message = "Bonjour,\n\n";
            message = message + "Votre lien Privil\u00e8ge a \u00e9t\u00e9 valid\u00e9. Vous pouvez d\u00e8s maintenant partager ce lien dans tous les groupes et r\u00e9seaux sociaux ou commentaires.\n\n";
            message = message + "A chaque cr\u00e9ation de compte avec ce lien, vous gagnerez 10 points qui augmenteront vos revenus.\n\n";
            message = message + mission.getLienprivilege();
            FormBody body = new FormBody.Builder().add("token", "dx0avb93wryxyd4f").add("to", "+" + mission.getCompte()).add("body", message).build();
            Request request = new Request.Builder().url("https://api.ultramsg.com/instance75373/messages/chat").post((RequestBody)body).addHeader("content-type", "application/x-www-form-urlencoded").build();
            Response response = null;
            try {
                response = client.newCall(request).execute();
                mission.setEstenvoyer(Boolean.valueOf(true));
                mission.setDateenvoi(new Date());
                mission.setStatus("Accept\u00e9");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                this.bugsCronService.SaveBugCron("cron d'envoi du lien privil\u00e8ge par whatsapp \u00e0 " + mission.getCompte(), e.getMessage());
            }
        }
        return missions;
    }

    public String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }

    public Transaction EnvoyerWhatsappConfirmationPaiement(Auteur auteur, Transaction transaction, long nbclics) {
        Locale locale = Locale.forLanguageTag("fr-FR");
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        String montantcalculer = numberFormat.format(transaction.getMontantcalculer());
        String montantapayer = numberFormat.format(transaction.getMontantapayer());
        String totalpoints = numberFormat.format(transaction.getPoints());
        String mois = this.capitalizeFirstLetter(transaction.getMois());
        String quand = "";
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        quand = "le " + formatter.format(transaction.getDatepaiement());
        String message = "Bjr " + auteur.getFirst_name() + ", vous avez re\u00e7u " + quand + " sur votre wallet " + montantapayer + "F. ";
        message = message + "Vous avez cumul\u00e9 " + totalpoints + " points en " + mois + ", dont le montant calcul\u00e9 r\u00e9el est " + montantcalculer + "F, ";
        message = message + "nous vous avons cr\u00e9dit\u00e9 " + montantapayer + "F.";
        if (auteur.getRole().equals("ami")) {
            message = message + "\nEn " + mois + " vous avez cliqu\u00e9 sur " + nbclics + " articles d'actualit\u00e9.";
        }
        OkHttpClient client = new OkHttpClient();
        FormBody body = new FormBody.Builder().add("token", "dx0avb93wryxyd4f").add("to", "+" + auteur.getNumwhatsapp()).add("body", message).build();
        Request request = new Request.Builder().url("https://api.ultramsg.com/instance75373/messages/chat").post((RequestBody)body).addHeader("content-type", "application/x-www-form-urlencoded").build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
            transaction.setSmsenvoyer(Boolean.valueOf(true));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.bugsCronService.SaveBugCron("cron d'envoi de la confirmation de paiement de " + mois + " par whatsapp au compte " + transaction.getUsername() + " ; id de la transaction: " + transaction.getId(), e.getMessage());
        }
        return transaction;
    }
}

