/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.DashboardAmiDTO;
import com.notrecontinent.webapi.LesDTOs.DashboardContributeurDTO;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.services.AuteurService;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/momar"})
@CrossOrigin(value={"*"})
public class AuteurController {
    @Autowired
    private AuteurService auteurService;

    @GetMapping(value={"/Auteur/dashboard/{id}"})
    public ResponseEntity<List<DashbordStats>> getDashboardStatsByAuteurID(@PathVariable(value="id") Long id) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Tableau de bord d'un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.getDashboardStatsByAuteurID(id);
    }

    @GetMapping(value={"/Auteur/dashboardStats/{id}"})
    public ResponseEntity<DashboardContributeurDTO> getDashboardStatsCoteServeurByAuteurID(@PathVariable(value="id") Long id) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Tableau de bord d'un contributeur c\u00f4t\u00e9 serveur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.getDashboardStatscoteserveurByAuteurID(id);
    }

    @GetMapping(value={"/Auteur/dashboardStatsAmi/{id}"})
    public ResponseEntity<DashboardAmiDTO> getDashboardStatsCoteServeurByAmiID(@PathVariable(value="id") Long id) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Tableau de bord d'un ami c\u00f4t\u00e9 serveur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.getDashboardStatscoteserveurByAmiID(id);
    }

    @GetMapping(value={"/Auteur/all"})
    public List<Auteur> getAllAuteurs() {
        return this.auteurService.getAllAuteurs();
    }

    @GetMapping(value={"/Auteur/verif/{username}/{pays}"})
    public Boolean verifUsername(@PathVariable(value="username") String username, @PathVariable(value="pays") String pays) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification de l'existence d'un compte activ\u00e9 par son num\u00e9ro de t\u00e9l\u00e9phone");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifUsername(username, pays);
    }

    @PostMapping(value={"/Auteur/verifresetpwdtoken"})
    public Boolean verifResetPwdToken(@RequestParam(value="token") String token, @RequestParam(value="email") String email) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification de la validit\u00e9 du token de r\u00e9initialisation de pwd");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifResetPwdToken(token, email);
    }

    @GetMapping(value={"/Auteur/verifcompte/{username}/{pays}"})
    public Boolean verifierUsername(@PathVariable(value="username") String username, @PathVariable(value="pays") String pays) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification de l'existence d'un compte");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifierUsernameUniquement(username, pays);
    }

    @GetMapping(value={"/Auteur/verifier/{pseudonyme}"})
    public Boolean verifPseudonyme(@PathVariable(value="pseudonyme") String pseudonyme) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification de l'existence d'un pseudonyme pour un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifPseudonyme(pseudonyme);
    }

    @GetMapping(value={"/Auteur/{id}"})
    public Auteur getAuteurByID(@PathVariable(value="id") Long id) {
        return this.auteurService.getAuteurByID(id);
    }

    @GetMapping(value={"/Auteur/pieces/{id}"})
    public ResponseEntity<Auteur> getAuteurWithPiecesByID(@PathVariable(value="id") Long id) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de la pi\u00e8ce recto/verso d'un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.getAuteurWithPiecesByID(id);
    }

    @PostMapping(value={"/Auteur/verifynumeroAndSendResetSmSCode"})
    public String verifyNumeroAndSendResetSmSCode(@RequestParam(value="numero") String numero) throws JsonProcessingException {
        return this.auteurService.verifyUsernameAndSendResetSmSCode(numero);
    }

    @PostMapping(value={"/Auteur/verifyUsernameAndSendSmSCode"})
    public String verifyUsernameAndSendSmSCode(@RequestParam(value="username") String username, @RequestParam(value="pays") String pays) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification du num\u00e9ro de t\u00e9l\u00e9phone et envoi du code de validation");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifyUsernameAndSendSmSCode(username, pays);
    }

    @PostMapping(value={"/Auteur/VerifierSmsCodeEtSaveAuteur/{code}"})
    public String VerifierSmsCodeEtSaveAuteur(@Validated @RequestBody Auteur auteur, @PathVariable(value="code") String code) throws MessagingException, IOException {
        return this.auteurService.VerifierSmsCodeEtSaveAuteur(auteur, code);
    }

    @PostMapping(value={"/Auteur/SendValidationEmail"})
    public String SendValidationEmail(@RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="pays") String pays) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Verification de l'existence du compte et Envoi du mail de confirmation de cr\u00e9ation de compte par email");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.SendValidationEmail(username, password, pays);
    }

    @PostMapping(value={"/Auteur/verifEmailAndSendResetPwdEmail"})
    public String verifEmailAndSendResetPwdEmail(@RequestParam(value="username") String username, @RequestParam(value="pays") String pays) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification de l'email et envoi du mail de r\u00e9initialisation de pwd");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.verifEmailAndSendResetPwdEmail(username, pays);
    }

    @PostMapping(value={"/Auteur/VerifEmailValidationTokenAndSaveAuteur"})
    public Auteur VerifEmailValidationTokenAndSaveAuteur(@RequestParam(value="token") String token) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("V\u00e9rification du token de confirmation de cr\u00e9ation de compte et cr\u00e9ation du compte");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.VerifEmailValidationTokenAndSaveAuteur(token);
    }

    @PostMapping(value={"/Auteur/authenticate"})
    public UserInfoResponse AuthenticateAuteurByUsernameAndPwd(@RequestParam(value="username") String username, @RequestParam(value="pwd") String pwd, @RequestParam(value="pays") String pays) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Authentification d'un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.getAuteurByUsernameAndPwd(username, pwd, pays);
    }

    @PostMapping(value={"/Auteur/deconnexion"})
    public String DeconnecterAuteur(@RequestParam(value="idconnexion") String idconnexion) throws ParseException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9connexion d'un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.Deconnexion(idconnexion);
    }

    @PostMapping(value={"/Auteur"})
    public Auteur SaveAuteur(@Validated @RequestBody Auteur auteur) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Cr\u00e9ation d'un compte contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.SaveAuteur(auteur);
    }

    @PutMapping(value={"/Auteur/update/{id}"})
    public ResponseEntity<Auteur> UpdateAuteur(@PathVariable(value="id") Long id, @Validated @RequestBody Auteur newauteur) throws MessagingException, IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification du profil par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.UpdateAuteur(id, newauteur);
    }

    @PutMapping(value={"/Auteur/updatepwd/{id}/{oldpwd}/{newpwd}"})
    public ResponseEntity<Auteur> Updatepwd(@PathVariable(value="id") Long id, @PathVariable(value="oldpwd") String oldpwd, @PathVariable(value="newpwd") String newpwd) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification du mot de passe par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.Updatepwd(id, oldpwd, newpwd);
    }

    @PutMapping(value={"/Auteur/resetpwd/{numero}/{newpwd}"})
    public Boolean ResetPwd(@PathVariable(value="numero") String numero, @PathVariable(value="newpwd") String newpwd) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9initialisation du mot de passe par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.ResetPwd(numero, newpwd);
    }

    @PutMapping(value={"/Auteur/updateidentitepiece/{id}"})
    public Auteur UpdateIdentiteWihPiece(@PathVariable(value="id") Long id, @RequestParam(value="piece") MultipartFile piece) {
        return this.auteurService.UpdateIdentiteWihPiece(id, piece);
    }

    @PutMapping(value={"/Auteur/updateidentiteautrepiece/{id}"})
    public Auteur UpdateIdentiteWihAutrePiece(@PathVariable(value="id") Long id, @RequestParam(value="autrepiece") MultipartFile autrepiece) {
        return this.auteurService.UpdateIdentiteWihAutrePiece(id, autrepiece);
    }

    @PutMapping(value={"/Auteur/updateidentitepieces/{id}"})
    public Auteur UpdateIdentiteWihPieceAndAutrePiece(@PathVariable(value="id") Long id, @RequestParam(value="piece") MultipartFile piece, @RequestParam(value="autrepiece") MultipartFile autrepiece, @RequestParam(value="typepiece") String typepiece, @RequestParam(value="numpiece") String numpiece) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification de la pi\u00e8ce d'identit\u00e9 par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.UpdateIdentiteWihPieceAndAutrePiece(id, piece, autrepiece, typepiece, numpiece);
    }

    @PutMapping(value={"/Auteur/updatebloquer/{id}/{etat}"})
    public Auteur Updatebloquer(@PathVariable(value="id") Long id, @PathVariable(value="etat") Boolean etat) {
        return this.auteurService.Updatebloquer(id, etat);
    }

    @PutMapping(value={"/Auteur/updatemonetisation/{id}/{etat}"})
    public ResponseEntity<Auteur> Updatemonetisation(@PathVariable(value="id") Long id, @PathVariable(value="etat") String etat) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification de la mon\u00e9tisation par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.auteurService.Updatemonetisation(id, etat);
    }

    @DeleteMapping(value={"/Auteur/delete/{id}"})
    public String DeleteAuteur(@PathVariable(value="id") Long id) {
        return this.auteurService.DeleteAuteur(id);
    }

    @DeleteMapping(value={"/Auteur/deleteall"})
    public String DeleteAllAuteurs() {
        return this.auteurService.DeleteAllAuteurs();
    }
}

