/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.LesDTOs.VerifSmsStatus;
import com.notrecontinent.webapi.dto.AuthToken;
import com.notrecontinent.webapi.dto.ResponseAuthToken;
import com.notrecontinent.webapi.dto.SensSMS;
import com.notrecontinent.webapi.dto.VerifCode;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.NumberFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SmsService {
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private RestTemplate restTemplate;
    private String message1 = "plongez dans nos derniers articles! Connectez-vous pour acc\u00e9der \u00e0 du contenu exclusif";
    private String message2 = "ne manquez pas nos derniers articles mise en ligne! Connectez-vous d\u00e8s maintenant pour rester inform\u00e9!";
    private String message3 = "d\u00e9couvrez nos tout nouveaux posts! Connectez-vous pour \u00eatre parmi les premiers \u00e0 lire et \u00e0 r\u00e9agir.";
    private String message4 = "nous avons publi\u00e9 de nouveaux articles. Connectez-vous pour en savoir plus!";
    private String message5 = "votre opinion compte! Connectez-vous pour lire nos derniers post et partager vos commentaires avec la communaut\u00e9.";
    @Value(value="${notification.numeromessage}")
    private int numeromessage;
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseAuthToken getAuthToken() {
        AuthToken authToken = new AuthToken("XorguiNC", "Tonti@Diatta9??");
        ResponseAuthToken responseAuthToken = (ResponseAuthToken)this.restTemplate.postForObject("https://sms.tinsight.tech/auth2/get_token_auth/", (Object)authToken, ResponseAuthToken.class, new Object[0]);
        return responseAuthToken;
    }

    public String SendValidationCode(String numero) throws JsonProcessingException {
        ResponseAuthToken responseAuthToken = this.getAuthToken();
        String token = responseAuthToken.getToken();
        return this.SendSMSCode(numero, token);
    }

    public String SendSMSCode(String numero, String authToken) {
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phone_number", numero);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/smscode/", HttpMethod.POST, requestEntity, String.class, new Object[0]);
        System.out.print("r\u00e9ponse : ");
        System.out.println(((String)response.getBody()).toString());
        return "code envoy\u00e9";
    }

    public VerifCode VerifSMSCode(String numero, String code, String authToken) {
        String token = this.getAuthToken().getToken();
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + token;
        headers.set("Authorization", authHeader);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phone_number", numero);
        map.put("code", code);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/verify_code/", HttpMethod.POST, requestEntity, VerifCode.class, new Object[0]);
        System.out.print("r\u00e9ponse : ");
        System.out.println(response.getBody());
        return (VerifCode)response.getBody();
    }

    public String EnvoyerSmsValidationArticle(String numero, String lastname, String civilite, String lien) {
        SensSMS sms = new SensSMS();
        ResponseAuthToken responseAuthToken = this.getAuthToken();
        if (responseAuthToken.getToken() != null) {
            String authToken = responseAuthToken.getToken();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Token " + authToken;
            headers.set("Authorization", authHeader);
            String salutation = "";
            LocalTime localTime = LocalTime.now();
            int currentHour = localTime.getHour();
            salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
            String civiliteAbregee = "";
            if (civilite.equals("Monsieur")) {
                civiliteAbregee = "Mr ";
            } else if (civilite.equals("Madame")) {
                civiliteAbregee = "Mme ";
            } else if (civilite.equals("Mademoiselle")) {
                civiliteAbregee = "Mlle ";
            }
            String message = salutation + civiliteAbregee + lastname + ", votre article a \u00e9t\u00e9 mis en ligne avec succ\u00e8s.\n";
            message = message + lien + "\n";
            message = message + "A tr\u00e8s bient\u00f4t";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", numero);
            map.put("message", message);
            HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/sms/", HttpMethod.POST, requestEntity, SensSMS.class, new Object[0]);
            sms = (SensSMS)response.getBody();
        }
        return sms.getMessage();
    }

    public NotificationSmsStatus SendNotificationAmi(String numero, String nomAmi, String parametreliensms) {
        String authToken = this.getAuthToken().getToken();
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        String body = "Bjr " + nomAmi + ",\n";
        body = body + "Clic le lien ci-dessous et acc\u00e8de \u00e0 l'actualit\u00e9 du jour. Consulte ton compte et augmente tes revenus.\n";
        body = body + "www.nc12.net/" + parametreliensms;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", numero);
        map.put("message", body);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        NotificationSmsStatus response = (NotificationSmsStatus)this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/sms/", HttpMethod.POST, requestEntity, NotificationSmsStatus.class, new Object[0]).getBody();
        System.out.print("r\u00e9ponse : ");
        System.out.println(response.toString());
        return response;
    }

    public NotificationSmsStatus EnvoyerSmsRecommandationAunAmi(String numeroExpediteur, String nomExpediteur, String numeroRecepteur, String nomRecepteur, String message) {
        String authToken = this.getAuthToken().getToken();
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        String body = "Bjr " + nomRecepteur + ", c'est " + nomExpediteur + " " + numeroExpediteur + ".\n";
        body = body + message + "\n";
        body = body + "www.nc12.net";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", numeroRecepteur);
        map.put("message", body);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        NotificationSmsStatus response = (NotificationSmsStatus)this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/sms/", HttpMethod.POST, requestEntity, NotificationSmsStatus.class, new Object[0]).getBody();
        System.out.print("r\u00e9ponse : ");
        System.out.println(response.toString());
        return response;
    }

    public VerifSmsStatus verifySmsStatus(String smsId) {
        String authToken = this.getAuthToken().getToken();
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        VerifSmsStatus[] response = (VerifSmsStatus[])this.restTemplate.exchange("https://sms.tinsinght.tech/apiv2/sms/?id=" + smsId, HttpMethod.POST, requestEntity, VerifSmsStatus[].class, new Object[0]).getBody();
        System.out.print("r\u00e9ponse : ");
        System.out.println(response.toString());
        return response[0];
    }

    public NotificationSmsStatus EnvoyerSMSConfirmationPaiement(String token, Auteur auteur, Transaction transaction, long coeff) {
        long revenu;
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + token;
        headers.set("Authorization", authHeader);
        Locale locale = Locale.forLanguageTag("fr-FR");
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        String montantcalculer = numberFormat.format(transaction.getMontantcalculer());
        String montantapayer = numberFormat.format(transaction.getMontantapayer());
        String mois = this.capitalizeFirstLetter(transaction.getMois());
        String body = "Bjr " + auteur.getFirst_name() + ", vous avez re\u00e7u hier sur votre wallet " + montantapayer + "F. ";
        body = body + "Pour info vous avez cumul\u00e9 " + transaction.getPoints() + " points en " + mois + ", dont le montant calcul\u00e9 r\u00e9el est " + montantcalculer + "F, ";
        body = body + "nous vous avons cr\u00e9dit\u00e9 " + montantapayer + "F.\n";
        if (auteur.getRole().equals("ami")) {
            revenu = coeff * 310L;
            body = body + "Si vous aviez cliqu\u00e9 sur toutes les notifications en " + mois + ", vous auriez eu 310 points pour un revenu de " + revenu + " FCFA.";
        } else if (auteur.getRole().equals("contributeur")) {
            revenu = coeff * 5000L;
            body = body + "Si vous aviez cr\u00e9\u00e9 50 articles en " + mois + " que nous validions, vous auriez eu 5000 points pour un revenu de " + revenu + " FCFA.";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", auteur.getTelephone());
        map.put("message", body);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        NotificationSmsStatus response = (NotificationSmsStatus)this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/sms/", HttpMethod.POST, requestEntity, NotificationSmsStatus.class, new Object[0]).getBody();
        return response;
    }

    public String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }

    public List<Long> Envoyeralertesfraudesclicrecommandations(List<List<String>> numeros) {
        ArrayList<Long> idsamis = new ArrayList<Long>();
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
        String authToken = this.getAuthToken().getToken();
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        for (List<String> numero : numeros) {
            String body = salutation + numero.get(2) + ", il est interdit de cliquer sur trois articles recommandation en moins de 2 minutes.";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("phone_number", numero.get(1));
            map.put("message", body);
            HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
            try {
                ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/smscode/", HttpMethod.POST, requestEntity, String.class, new Object[0]);
                idsamis.add(Long.valueOf(numero.get(0)));
                System.out.print("r\u00e9ponse : ");
                System.out.println(((String)response.getBody()).toString());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return idsamis;
    }

    public List<Lienprivilege> EnvoyerLiensPrivileges(List<Lienprivilege> missions) {
        try {
            String authToken = this.getAuthToken().getToken();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Token " + authToken;
            headers.set("Authorization", authHeader);
            for (Lienprivilege mission : missions) {
                String body = "Bonjour,\n\n";
                body = body + "Votre lien Privil\u00e8ge a \u00e9t\u00e9 valid\u00e9. Vous pouvez d\u00e8s maintenant partager ce lien dans tous les groupes et r\u00e9seaux sociaux ou commentaires.\n\n";
                body = body + "A chaque cr\u00e9ation de compte avec ce lien, vous gagnerez 10 points qui augmenteront vos revenus.\n\n";
                body = body + mission.getLienprivilege();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("phone_number", mission.getCompte());
                map.put("message", body);
                HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
                try {
                    ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/smscode/", HttpMethod.POST, requestEntity, String.class, new Object[0]);
                    mission.setEstenvoyer(Boolean.valueOf(true));
                    mission.setDateenvoi(new Date());
                    mission.setStatus("Accept\u00e9");
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    this.bugsCronService.SaveBugCron("cron d'envoi du lien privil\u00e8ge par SMS \u00e0 " + mission.getCompte(), e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.bugsCronService.SaveBugCron("cron d'envoi de liens privil\u00e8ges par email", e.getMessage());
        }
        return missions;
    }
}

