/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.security.jwt;

import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.security.services.UserDetailsServiceImpl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String tokenHeader;
        String compte = request.getHeader("compte");
        if (compte != null) {
            System.out.println("compte:" + compte);
        }
        if ((tokenHeader = request.getHeader("Authorization")) != null && tokenHeader.startsWith("Bearer ")) {
            String jwt = tokenHeader.substring(7);
            try {
                if (jwt != null && this.jwtUtils.validateJwtToken(jwt)) {
                    String username = this.jwtUtils.getUserNameFromJwtToken(jwt);
                    UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                }
            }
            catch (Exception e) {
                logger.error("Cannot set user authentication: {}", (Throwable)e);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

